package com.spotify.styx.model;

import io.norberg.automatter.AutoMatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("io.norberg.automatter.processor.AutoMatterProcessor")
public final class ExecutionDescriptionBuilder {
  private String dockerImage;

  private List<String> dockerArgs;

  private boolean dockerTerminationLogging;

  private Optional<WorkflowConfiguration.Secret> secret;

  private Optional<String> serviceAccount;

  private Optional<String> commitSha;

  private Map<String, String> env;

  public ExecutionDescriptionBuilder() {
    this.secret = Optional.empty();
    this.serviceAccount = Optional.empty();
    this.commitSha = Optional.empty();
  }

  private ExecutionDescriptionBuilder(ExecutionDescription v) {
    this.dockerImage = v.dockerImage();
    List<String> _dockerArgs = v.dockerArgs();
    this.dockerArgs = (_dockerArgs == null) ? null : new ArrayList<String>(_dockerArgs);
    this.dockerTerminationLogging = v.dockerTerminationLogging();
    this.secret = v.secret();
    this.serviceAccount = v.serviceAccount();
    this.commitSha = v.commitSha();
    Map<String, String> _env = v.env();
    this.env = (_env == null) ? null : new HashMap<String, String>(_env);
  }

  private ExecutionDescriptionBuilder(ExecutionDescriptionBuilder v) {
    this.dockerImage = v.dockerImage;
    this.dockerArgs = (v.dockerArgs == null) ? null : new ArrayList<String>(v.dockerArgs);
    this.dockerTerminationLogging = v.dockerTerminationLogging;
    this.secret = v.secret;
    this.serviceAccount = v.serviceAccount;
    this.commitSha = v.commitSha;
    this.env = (v.env == null) ? null : new HashMap<String, String>(v.env);
  }

  public String dockerImage() {
    return dockerImage;
  }

  public ExecutionDescriptionBuilder dockerImage(String dockerImage) {
    if (dockerImage == null) {
      throw new NullPointerException("dockerImage");
    }
    this.dockerImage = dockerImage;
    return this;
  }

  public List<String> dockerArgs() {
    if (this.dockerArgs == null) {
      this.dockerArgs = new ArrayList<String>();
    }
    return dockerArgs;
  }

  public ExecutionDescriptionBuilder dockerArgs(List<? extends String> dockerArgs) {
    return dockerArgs((Collection<? extends String>) dockerArgs);
  }

  public ExecutionDescriptionBuilder dockerArgs(Collection<? extends String> dockerArgs) {
    if (dockerArgs == null) {
      throw new NullPointerException("dockerArgs");
    }
    for (String item : dockerArgs) {
      if (item == null) {
        throw new NullPointerException("dockerArgs: null item");
      }
    }
    this.dockerArgs = new ArrayList<String>(dockerArgs);
    return this;
  }

  public ExecutionDescriptionBuilder dockerArgs(Iterable<? extends String> dockerArgs) {
    if (dockerArgs == null) {
      throw new NullPointerException("dockerArgs");
    }
    if (dockerArgs instanceof Collection) {
      return dockerArgs((Collection<? extends String>) dockerArgs);
    }
    return dockerArgs(dockerArgs.iterator());
  }

  public ExecutionDescriptionBuilder dockerArgs(Iterator<? extends String> dockerArgs) {
    if (dockerArgs == null) {
      throw new NullPointerException("dockerArgs");
    }
    this.dockerArgs = new ArrayList<String>();
    while (dockerArgs.hasNext()) {
      String item = dockerArgs.next();
      if (item == null) {
        throw new NullPointerException("dockerArgs: null item");
      }
      this.dockerArgs.add(item);
    }
    return this;
  }

  @SafeVarargs
  public final ExecutionDescriptionBuilder dockerArgs(String... dockerArgs) {
    if (dockerArgs == null) {
      throw new NullPointerException("dockerArgs");
    }
    return dockerArgs(Arrays.asList(dockerArgs));
  }

  public ExecutionDescriptionBuilder addDockerArg(String dockerArg) {
    if (dockerArg == null) {
      throw new NullPointerException("dockerArg");
    }
    if (this.dockerArgs == null) {
      this.dockerArgs = new ArrayList<String>();
    }
    dockerArgs.add(dockerArg);
    return this;
  }

  public boolean dockerTerminationLogging() {
    return dockerTerminationLogging;
  }

  public ExecutionDescriptionBuilder dockerTerminationLogging(boolean dockerTerminationLogging) {
    this.dockerTerminationLogging = dockerTerminationLogging;
    return this;
  }

  public Optional<WorkflowConfiguration.Secret> secret() {
    return secret;
  }

  public ExecutionDescriptionBuilder secret(WorkflowConfiguration.Secret secret) {
    return secret(Optional.ofNullable(secret));
  }

  @SuppressWarnings("unchecked")
  public ExecutionDescriptionBuilder secret(
      Optional<? extends WorkflowConfiguration.Secret> secret) {
    if (secret == null) {
      throw new NullPointerException("secret");
    }
    this.secret = (Optional<WorkflowConfiguration.Secret>)secret;
    return this;
  }

  public Optional<String> serviceAccount() {
    return serviceAccount;
  }

  public ExecutionDescriptionBuilder serviceAccount(String serviceAccount) {
    return serviceAccount(Optional.ofNullable(serviceAccount));
  }

  @SuppressWarnings("unchecked")
  public ExecutionDescriptionBuilder serviceAccount(Optional<? extends String> serviceAccount) {
    if (serviceAccount == null) {
      throw new NullPointerException("serviceAccount");
    }
    this.serviceAccount = (Optional<String>)serviceAccount;
    return this;
  }

  public Optional<String> commitSha() {
    return commitSha;
  }

  public ExecutionDescriptionBuilder commitSha(String commitSha) {
    return commitSha(Optional.ofNullable(commitSha));
  }

  @SuppressWarnings("unchecked")
  public ExecutionDescriptionBuilder commitSha(Optional<? extends String> commitSha) {
    if (commitSha == null) {
      throw new NullPointerException("commitSha");
    }
    this.commitSha = (Optional<String>)commitSha;
    return this;
  }

  public Map<String, String> env() {
    if (this.env == null) {
      this.env = new HashMap<String, String>();
    }
    return env;
  }

  public ExecutionDescriptionBuilder env(Map<? extends String, ? extends String> env) {
    if (env == null) {
      throw new NullPointerException("env");
    }
    for (Map.Entry<? extends String, ? extends String> entry : env.entrySet()) {
      if (entry.getKey() == null) {
        throw new NullPointerException("env: null key");
      }
      if (entry.getValue() == null) {
        throw new NullPointerException("env: null value");
      }
    }
    this.env = new HashMap<String, String>(env);
    return this;
  }

  public ExecutionDescriptionBuilder env(String k1, String v1) {
    if (k1 == null) {
      throw new NullPointerException("env: k1");
    }
    if (v1 == null) {
      throw new NullPointerException("env: v1");
    }
    env = new HashMap<String, String>();
    env.put(k1, v1);
    return this;
  }

  public ExecutionDescriptionBuilder env(String k1, String v1, String k2, String v2) {
    env(k1, v1);
    if (k2 == null) {
      throw new NullPointerException("env: k2");
    }
    if (v2 == null) {
      throw new NullPointerException("env: v2");
    }
    env.put(k2, v2);
    return this;
  }

  public ExecutionDescriptionBuilder env(String k1, String v1, String k2, String v2, String k3,
      String v3) {
    env(k1, v1, k2, v2);
    if (k3 == null) {
      throw new NullPointerException("env: k3");
    }
    if (v3 == null) {
      throw new NullPointerException("env: v3");
    }
    env.put(k3, v3);
    return this;
  }

  public ExecutionDescriptionBuilder env(String k1, String v1, String k2, String v2, String k3,
      String v3, String k4, String v4) {
    env(k1, v1, k2, v2, k3, v3);
    if (k4 == null) {
      throw new NullPointerException("env: k4");
    }
    if (v4 == null) {
      throw new NullPointerException("env: v4");
    }
    env.put(k4, v4);
    return this;
  }

  public ExecutionDescriptionBuilder env(String k1, String v1, String k2, String v2, String k3,
      String v3, String k4, String v4, String k5, String v5) {
    env(k1, v1, k2, v2, k3, v3, k4, v4);
    if (k5 == null) {
      throw new NullPointerException("env: k5");
    }
    if (v5 == null) {
      throw new NullPointerException("env: v5");
    }
    env.put(k5, v5);
    return this;
  }

  public ExecutionDescription build() {
    List<String> _dockerArgs = (dockerArgs != null) ? Collections.unmodifiableList(new ArrayList<String>(dockerArgs)) : Collections.<String>emptyList();
    Map<String, String> _env = (env != null) ? Collections.unmodifiableMap(new HashMap<String, String>(env)) : Collections.<String, String>emptyMap();
    return new Value(dockerImage, _dockerArgs, dockerTerminationLogging, secret, serviceAccount, commitSha, _env);
  }

  public static ExecutionDescriptionBuilder from(ExecutionDescription v) {
    return new ExecutionDescriptionBuilder(v);
  }

  public static ExecutionDescriptionBuilder from(ExecutionDescriptionBuilder v) {
    return new ExecutionDescriptionBuilder(v);
  }

  private static final class Value implements ExecutionDescription {
    private final String dockerImage;

    private final List<String> dockerArgs;

    private final boolean dockerTerminationLogging;

    private final Optional<WorkflowConfiguration.Secret> secret;

    private final Optional<String> serviceAccount;

    private final Optional<String> commitSha;

    private final Map<String, String> env;

    private Value(@AutoMatter.Field("dockerImage") String dockerImage,
        @AutoMatter.Field("dockerArgs") List<String> dockerArgs,
        @AutoMatter.Field("dockerTerminationLogging") boolean dockerTerminationLogging,
        @AutoMatter.Field("secret") Optional<WorkflowConfiguration.Secret> secret,
        @AutoMatter.Field("serviceAccount") Optional<String> serviceAccount,
        @AutoMatter.Field("commitSha") Optional<String> commitSha,
        @AutoMatter.Field("env") Map<String, String> env) {
      if (dockerImage == null) {
        throw new NullPointerException("dockerImage");
      }
      if (secret == null) {
        throw new NullPointerException("secret");
      }
      if (serviceAccount == null) {
        throw new NullPointerException("serviceAccount");
      }
      if (commitSha == null) {
        throw new NullPointerException("commitSha");
      }
      this.dockerImage = dockerImage;
      this.dockerArgs = (dockerArgs != null) ? dockerArgs : Collections.<String>emptyList();
      this.dockerTerminationLogging = dockerTerminationLogging;
      this.secret = secret;
      this.serviceAccount = serviceAccount;
      this.commitSha = commitSha;
      this.env = (env != null) ? env : Collections.<String, String>emptyMap();
    }

    @AutoMatter.Field
    @Override
    public String dockerImage() {
      return dockerImage;
    }

    @AutoMatter.Field
    @Override
    public List<String> dockerArgs() {
      return dockerArgs;
    }

    @AutoMatter.Field
    @Override
    public boolean dockerTerminationLogging() {
      return dockerTerminationLogging;
    }

    @AutoMatter.Field
    @Override
    public Optional<WorkflowConfiguration.Secret> secret() {
      return secret;
    }

    @AutoMatter.Field
    @Override
    public Optional<String> serviceAccount() {
      return serviceAccount;
    }

    @AutoMatter.Field
    @Override
    public Optional<String> commitSha() {
      return commitSha;
    }

    @AutoMatter.Field
    @Override
    public Map<String, String> env() {
      return env;
    }

    public ExecutionDescriptionBuilder builder() {
      return new ExecutionDescriptionBuilder(this);
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (!(o instanceof ExecutionDescription)) {
        return false;
      }
      final ExecutionDescription that = (ExecutionDescription) o;
      if (dockerImage != null ? !dockerImage.equals(that.dockerImage()) : that.dockerImage() != null) {
        return false;
      }
      if (dockerArgs != null ? !dockerArgs.equals(that.dockerArgs()) : that.dockerArgs() != null) {
        return false;
      }
      if (dockerTerminationLogging != that.dockerTerminationLogging()) {
        return false;
      }
      if (secret != null ? !secret.equals(that.secret()) : that.secret() != null) {
        return false;
      }
      if (serviceAccount != null ? !serviceAccount.equals(that.serviceAccount()) : that.serviceAccount() != null) {
        return false;
      }
      if (commitSha != null ? !commitSha.equals(that.commitSha()) : that.commitSha() != null) {
        return false;
      }
      if (env != null ? !env.equals(that.env()) : that.env() != null) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      long temp;
      result = 31 * result + (this.dockerImage != null ? this.dockerImage.hashCode() : 0);
      result = 31 * result + (this.dockerArgs != null ? this.dockerArgs.hashCode() : 0);
      result = 31 * result + (this.dockerTerminationLogging ? 1231 : 1237);
      result = 31 * result + (this.secret != null ? this.secret.hashCode() : 0);
      result = 31 * result + (this.serviceAccount != null ? this.serviceAccount.hashCode() : 0);
      result = 31 * result + (this.commitSha != null ? this.commitSha.hashCode() : 0);
      result = 31 * result + (this.env != null ? this.env.hashCode() : 0);
      return result;
    }

    @Override
    public String toString() {
      return "ExecutionDescription{" +
      "dockerImage=" + dockerImage +
      ", dockerArgs=" + dockerArgs +
      ", dockerTerminationLogging=" + dockerTerminationLogging +
      ", secret=" + secret +
      ", serviceAccount=" + serviceAccount +
      ", commitSha=" + commitSha +
      ", env=" + env +
      '}';
    }
  }
}
