package com.spotify.styx.model;

import io.norberg.automatter.AutoMatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("io.norberg.automatter.processor.AutoMatterProcessor")
public final class StyxConfigBuilder {
  private String globalDockerRunnerId;

  private boolean globalEnabled;

  private boolean debugEnabled;

  private boolean executionGatingEnabled;

  private Optional<Long> globalConcurrency;

  private Optional<Double> submissionRateLimit;

  private List<String> clientBlacklist;

  public StyxConfigBuilder() {
    this.globalConcurrency = Optional.empty();
    this.submissionRateLimit = Optional.empty();
  }

  private StyxConfigBuilder(StyxConfig v) {
    this.globalDockerRunnerId = v.globalDockerRunnerId();
    this.globalEnabled = v.globalEnabled();
    this.debugEnabled = v.debugEnabled();
    this.executionGatingEnabled = v.executionGatingEnabled();
    this.globalConcurrency = v.globalConcurrency();
    this.submissionRateLimit = v.submissionRateLimit();
    List<String> _clientBlacklist = v.clientBlacklist();
    this.clientBlacklist = (_clientBlacklist == null) ? null : new ArrayList<String>(_clientBlacklist);
  }

  private StyxConfigBuilder(StyxConfigBuilder v) {
    this.globalDockerRunnerId = v.globalDockerRunnerId;
    this.globalEnabled = v.globalEnabled;
    this.debugEnabled = v.debugEnabled;
    this.executionGatingEnabled = v.executionGatingEnabled;
    this.globalConcurrency = v.globalConcurrency;
    this.submissionRateLimit = v.submissionRateLimit;
    this.clientBlacklist = (v.clientBlacklist == null) ? null : new ArrayList<String>(v.clientBlacklist);
  }

  public String globalDockerRunnerId() {
    return globalDockerRunnerId;
  }

  public StyxConfigBuilder globalDockerRunnerId(String globalDockerRunnerId) {
    if (globalDockerRunnerId == null) {
      throw new NullPointerException("globalDockerRunnerId");
    }
    this.globalDockerRunnerId = globalDockerRunnerId;
    return this;
  }

  public boolean globalEnabled() {
    return globalEnabled;
  }

  public StyxConfigBuilder globalEnabled(boolean globalEnabled) {
    this.globalEnabled = globalEnabled;
    return this;
  }

  public boolean debugEnabled() {
    return debugEnabled;
  }

  public StyxConfigBuilder debugEnabled(boolean debugEnabled) {
    this.debugEnabled = debugEnabled;
    return this;
  }

  public boolean executionGatingEnabled() {
    return executionGatingEnabled;
  }

  public StyxConfigBuilder executionGatingEnabled(boolean executionGatingEnabled) {
    this.executionGatingEnabled = executionGatingEnabled;
    return this;
  }

  public Optional<Long> globalConcurrency() {
    return globalConcurrency;
  }

  public StyxConfigBuilder globalConcurrency(Long globalConcurrency) {
    return globalConcurrency(Optional.ofNullable(globalConcurrency));
  }

  @SuppressWarnings("unchecked")
  public StyxConfigBuilder globalConcurrency(Optional<? extends Long> globalConcurrency) {
    if (globalConcurrency == null) {
      throw new NullPointerException("globalConcurrency");
    }
    this.globalConcurrency = (Optional<Long>)globalConcurrency;
    return this;
  }

  public Optional<Double> submissionRateLimit() {
    return submissionRateLimit;
  }

  public StyxConfigBuilder submissionRateLimit(Double submissionRateLimit) {
    return submissionRateLimit(Optional.ofNullable(submissionRateLimit));
  }

  @SuppressWarnings("unchecked")
  public StyxConfigBuilder submissionRateLimit(Optional<? extends Double> submissionRateLimit) {
    if (submissionRateLimit == null) {
      throw new NullPointerException("submissionRateLimit");
    }
    this.submissionRateLimit = (Optional<Double>)submissionRateLimit;
    return this;
  }

  public List<String> clientBlacklist() {
    if (this.clientBlacklist == null) {
      this.clientBlacklist = new ArrayList<String>();
    }
    return clientBlacklist;
  }

  public StyxConfigBuilder clientBlacklist(List<? extends String> clientBlacklist) {
    return clientBlacklist((Collection<? extends String>) clientBlacklist);
  }

  public StyxConfigBuilder clientBlacklist(Collection<? extends String> clientBlacklist) {
    if (clientBlacklist == null) {
      throw new NullPointerException("clientBlacklist");
    }
    for (String item : clientBlacklist) {
      if (item == null) {
        throw new NullPointerException("clientBlacklist: null item");
      }
    }
    this.clientBlacklist = new ArrayList<String>(clientBlacklist);
    return this;
  }

  public StyxConfigBuilder clientBlacklist(Iterable<? extends String> clientBlacklist) {
    if (clientBlacklist == null) {
      throw new NullPointerException("clientBlacklist");
    }
    if (clientBlacklist instanceof Collection) {
      return clientBlacklist((Collection<? extends String>) clientBlacklist);
    }
    return clientBlacklist(clientBlacklist.iterator());
  }

  public StyxConfigBuilder clientBlacklist(Iterator<? extends String> clientBlacklist) {
    if (clientBlacklist == null) {
      throw new NullPointerException("clientBlacklist");
    }
    this.clientBlacklist = new ArrayList<String>();
    while (clientBlacklist.hasNext()) {
      String item = clientBlacklist.next();
      if (item == null) {
        throw new NullPointerException("clientBlacklist: null item");
      }
      this.clientBlacklist.add(item);
    }
    return this;
  }

  @SafeVarargs
  public final StyxConfigBuilder clientBlacklist(String... clientBlacklist) {
    if (clientBlacklist == null) {
      throw new NullPointerException("clientBlacklist");
    }
    return clientBlacklist(Arrays.asList(clientBlacklist));
  }

  public StyxConfig build() {
    List<String> _clientBlacklist = (clientBlacklist != null) ? Collections.unmodifiableList(new ArrayList<String>(clientBlacklist)) : Collections.<String>emptyList();
    return new Value(globalDockerRunnerId, globalEnabled, debugEnabled, executionGatingEnabled, globalConcurrency, submissionRateLimit, _clientBlacklist);
  }

  public static StyxConfigBuilder from(StyxConfig v) {
    return new StyxConfigBuilder(v);
  }

  public static StyxConfigBuilder from(StyxConfigBuilder v) {
    return new StyxConfigBuilder(v);
  }

  private static final class Value implements StyxConfig {
    private final String globalDockerRunnerId;

    private final boolean globalEnabled;

    private final boolean debugEnabled;

    private final boolean executionGatingEnabled;

    private final Optional<Long> globalConcurrency;

    private final Optional<Double> submissionRateLimit;

    private final List<String> clientBlacklist;

    private Value(@AutoMatter.Field("globalDockerRunnerId") String globalDockerRunnerId,
        @AutoMatter.Field("globalEnabled") boolean globalEnabled,
        @AutoMatter.Field("debugEnabled") boolean debugEnabled,
        @AutoMatter.Field("executionGatingEnabled") boolean executionGatingEnabled,
        @AutoMatter.Field("globalConcurrency") Optional<Long> globalConcurrency,
        @AutoMatter.Field("submissionRateLimit") Optional<Double> submissionRateLimit,
        @AutoMatter.Field("clientBlacklist") List<String> clientBlacklist) {
      if (globalDockerRunnerId == null) {
        throw new NullPointerException("globalDockerRunnerId");
      }
      if (globalConcurrency == null) {
        throw new NullPointerException("globalConcurrency");
      }
      if (submissionRateLimit == null) {
        throw new NullPointerException("submissionRateLimit");
      }
      this.globalDockerRunnerId = globalDockerRunnerId;
      this.globalEnabled = globalEnabled;
      this.debugEnabled = debugEnabled;
      this.executionGatingEnabled = executionGatingEnabled;
      this.globalConcurrency = globalConcurrency;
      this.submissionRateLimit = submissionRateLimit;
      this.clientBlacklist = (clientBlacklist != null) ? clientBlacklist : Collections.<String>emptyList();
    }

    @AutoMatter.Field
    @Override
    public String globalDockerRunnerId() {
      return globalDockerRunnerId;
    }

    @AutoMatter.Field
    @Override
    public boolean globalEnabled() {
      return globalEnabled;
    }

    @AutoMatter.Field
    @Override
    public boolean debugEnabled() {
      return debugEnabled;
    }

    @AutoMatter.Field
    @Override
    public boolean executionGatingEnabled() {
      return executionGatingEnabled;
    }

    @AutoMatter.Field
    @Override
    public Optional<Long> globalConcurrency() {
      return globalConcurrency;
    }

    @AutoMatter.Field
    @Override
    public Optional<Double> submissionRateLimit() {
      return submissionRateLimit;
    }

    @AutoMatter.Field
    @Override
    public List<String> clientBlacklist() {
      return clientBlacklist;
    }

    public StyxConfigBuilder builder() {
      return new StyxConfigBuilder(this);
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (!(o instanceof StyxConfig)) {
        return false;
      }
      final StyxConfig that = (StyxConfig) o;
      if (globalDockerRunnerId != null ? !globalDockerRunnerId.equals(that.globalDockerRunnerId()) : that.globalDockerRunnerId() != null) {
        return false;
      }
      if (globalEnabled != that.globalEnabled()) {
        return false;
      }
      if (debugEnabled != that.debugEnabled()) {
        return false;
      }
      if (executionGatingEnabled != that.executionGatingEnabled()) {
        return false;
      }
      if (globalConcurrency != null ? !globalConcurrency.equals(that.globalConcurrency()) : that.globalConcurrency() != null) {
        return false;
      }
      if (submissionRateLimit != null ? !submissionRateLimit.equals(that.submissionRateLimit()) : that.submissionRateLimit() != null) {
        return false;
      }
      if (clientBlacklist != null ? !clientBlacklist.equals(that.clientBlacklist()) : that.clientBlacklist() != null) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      long temp;
      result = 31 * result + (this.globalDockerRunnerId != null ? this.globalDockerRunnerId.hashCode() : 0);
      result = 31 * result + (this.globalEnabled ? 1231 : 1237);
      result = 31 * result + (this.debugEnabled ? 1231 : 1237);
      result = 31 * result + (this.executionGatingEnabled ? 1231 : 1237);
      result = 31 * result + (this.globalConcurrency != null ? this.globalConcurrency.hashCode() : 0);
      result = 31 * result + (this.submissionRateLimit != null ? this.submissionRateLimit.hashCode() : 0);
      result = 31 * result + (this.clientBlacklist != null ? this.clientBlacklist.hashCode() : 0);
      return result;
    }

    @Override
    public String toString() {
      return "StyxConfig{" +
      "globalDockerRunnerId=" + globalDockerRunnerId +
      ", globalEnabled=" + globalEnabled +
      ", debugEnabled=" + debugEnabled +
      ", executionGatingEnabled=" + executionGatingEnabled +
      ", globalConcurrency=" + globalConcurrency +
      ", submissionRateLimit=" + submissionRateLimit +
      ", clientBlacklist=" + clientBlacklist +
      '}';
    }
  }
}
