package com.spotify.styx.model;

import io.norberg.automatter.AutoMatter;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("io.norberg.automatter.processor.AutoMatterProcessor")
public final class TriggerRequestBuilder {
  private WorkflowId workflowId;

  private String parameter;

  private Optional<TriggerParameters> triggerParameters;

  public TriggerRequestBuilder() {
    this.triggerParameters = Optional.empty();
  }

  private TriggerRequestBuilder(TriggerRequest v) {
    this.workflowId = v.workflowId();
    this.parameter = v.parameter();
    this.triggerParameters = v.triggerParameters();
  }

  private TriggerRequestBuilder(TriggerRequestBuilder v) {
    this.workflowId = v.workflowId;
    this.parameter = v.parameter;
    this.triggerParameters = v.triggerParameters;
  }

  public WorkflowId workflowId() {
    return workflowId;
  }

  public TriggerRequestBuilder workflowId(WorkflowId workflowId) {
    if (workflowId == null) {
      throw new NullPointerException("workflowId");
    }
    this.workflowId = workflowId;
    return this;
  }

  public String parameter() {
    return parameter;
  }

  public TriggerRequestBuilder parameter(String parameter) {
    if (parameter == null) {
      throw new NullPointerException("parameter");
    }
    this.parameter = parameter;
    return this;
  }

  public Optional<TriggerParameters> triggerParameters() {
    return triggerParameters;
  }

  public TriggerRequestBuilder triggerParameters(TriggerParameters triggerParameters) {
    return triggerParameters(Optional.ofNullable(triggerParameters));
  }

  @SuppressWarnings("unchecked")
  public TriggerRequestBuilder triggerParameters(
      Optional<? extends TriggerParameters> triggerParameters) {
    if (triggerParameters == null) {
      throw new NullPointerException("triggerParameters");
    }
    this.triggerParameters = (Optional<TriggerParameters>)triggerParameters;
    return this;
  }

  public TriggerRequest build() {
    return new Value(workflowId, parameter, triggerParameters);
  }

  public static TriggerRequestBuilder from(TriggerRequest v) {
    return new TriggerRequestBuilder(v);
  }

  public static TriggerRequestBuilder from(TriggerRequestBuilder v) {
    return new TriggerRequestBuilder(v);
  }

  private static final class Value implements TriggerRequest {
    private final WorkflowId workflowId;

    private final String parameter;

    private final Optional<TriggerParameters> triggerParameters;

    private Value(@AutoMatter.Field("workflowId") WorkflowId workflowId,
        @AutoMatter.Field("parameter") String parameter,
        @AutoMatter.Field("triggerParameters") Optional<TriggerParameters> triggerParameters) {
      if (workflowId == null) {
        throw new NullPointerException("workflowId");
      }
      if (parameter == null) {
        throw new NullPointerException("parameter");
      }
      if (triggerParameters == null) {
        throw new NullPointerException("triggerParameters");
      }
      this.workflowId = workflowId;
      this.parameter = parameter;
      this.triggerParameters = triggerParameters;
    }

    @AutoMatter.Field
    @Override
    public WorkflowId workflowId() {
      return workflowId;
    }

    @AutoMatter.Field
    @Override
    public String parameter() {
      return parameter;
    }

    @AutoMatter.Field
    @Override
    public Optional<TriggerParameters> triggerParameters() {
      return triggerParameters;
    }

    public TriggerRequestBuilder builder() {
      return new TriggerRequestBuilder(this);
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (!(o instanceof TriggerRequest)) {
        return false;
      }
      final TriggerRequest that = (TriggerRequest) o;
      if (workflowId != null ? !workflowId.equals(that.workflowId()) : that.workflowId() != null) {
        return false;
      }
      if (parameter != null ? !parameter.equals(that.parameter()) : that.parameter() != null) {
        return false;
      }
      if (triggerParameters != null ? !triggerParameters.equals(that.triggerParameters()) : that.triggerParameters() != null) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      long temp;
      result = 31 * result + (this.workflowId != null ? this.workflowId.hashCode() : 0);
      result = 31 * result + (this.parameter != null ? this.parameter.hashCode() : 0);
      result = 31 * result + (this.triggerParameters != null ? this.triggerParameters.hashCode() : 0);
      return result;
    }

    @Override
    public String toString() {
      return "TriggerRequest{" +
      "workflowId=" + workflowId +
      ", parameter=" + parameter +
      ", triggerParameters=" + triggerParameters +
      '}';
    }
  }
}
