package com.spotify.styx.state;

import io.norberg.automatter.AutoMatter;
import javax.annotation.Generated;

@Generated("io.norberg.automatter.processor.AutoMatterProcessor")
public final class MessageBuilder {
  private Message.MessageLevel level;

  private String line;

  public MessageBuilder() {
  }

  private MessageBuilder(Message v) {
    this.level = v.level();
    this.line = v.line();
  }

  private MessageBuilder(MessageBuilder v) {
    this.level = v.level;
    this.line = v.line;
  }

  public Message.MessageLevel level() {
    return level;
  }

  public MessageBuilder level(Message.MessageLevel level) {
    if (level == null) {
      throw new NullPointerException("level");
    }
    this.level = level;
    return this;
  }

  public String line() {
    return line;
  }

  public MessageBuilder line(String line) {
    if (line == null) {
      throw new NullPointerException("line");
    }
    this.line = line;
    return this;
  }

  public Message build() {
    return new Value(level, line);
  }

  public static MessageBuilder from(Message v) {
    return new MessageBuilder(v);
  }

  public static MessageBuilder from(MessageBuilder v) {
    return new MessageBuilder(v);
  }

  private static final class Value implements Message {
    private final Message.MessageLevel level;

    private final String line;

    private Value(@AutoMatter.Field("level") Message.MessageLevel level,
        @AutoMatter.Field("line") String line) {
      if (level == null) {
        throw new NullPointerException("level");
      }
      if (line == null) {
        throw new NullPointerException("line");
      }
      this.level = level;
      this.line = line;
    }

    @AutoMatter.Field
    @Override
    public Message.MessageLevel level() {
      return level;
    }

    @AutoMatter.Field
    @Override
    public String line() {
      return line;
    }

    public MessageBuilder builder() {
      return new MessageBuilder(this);
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (!(o instanceof Message)) {
        return false;
      }
      final Message that = (Message) o;
      if (level != null ? !level.equals(that.level()) : that.level() != null) {
        return false;
      }
      if (line != null ? !line.equals(that.line()) : that.line() != null) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      long temp;
      result = 31 * result + (this.level != null ? this.level.hashCode() : 0);
      result = 31 * result + (this.line != null ? this.line.hashCode() : 0);
      return result;
    }

    @Override
    public String toString() {
      return "Message{" +
      "level=" + level +
      ", line=" + line +
      '}';
    }
  }
}
