package com.spotify.styx.state;

import com.spotify.styx.model.ExecutionDescription;
import com.spotify.styx.model.TriggerParameters;
import io.norberg.automatter.AutoMatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Generated;

@Generated("io.norberg.automatter.processor.AutoMatterProcessor")
public final class StateDataBuilder {
  private int tries;

  private int consecutiveFailures;

  private double retryCost;

  private Optional<Long> retryDelayMillis;

  private Optional<Integer> lastExit;

  private Optional<Trigger> trigger;

  private Optional<String> triggerId;

  private Optional<String> executionId;

  private Optional<ExecutionDescription> executionDescription;

  private Optional<Set<String>> resourceIds;

  private Optional<TriggerParameters> triggerParameters;

  private List<Message> messages;

  public StateDataBuilder() {
    this.retryDelayMillis = Optional.empty();
    this.lastExit = Optional.empty();
    this.trigger = Optional.empty();
    this.triggerId = Optional.empty();
    this.executionId = Optional.empty();
    this.executionDescription = Optional.empty();
    this.resourceIds = Optional.empty();
    this.triggerParameters = Optional.empty();
  }

  private StateDataBuilder(StateData v) {
    this.tries = v.tries();
    this.consecutiveFailures = v.consecutiveFailures();
    this.retryCost = v.retryCost();
    this.retryDelayMillis = v.retryDelayMillis();
    this.lastExit = v.lastExit();
    this.trigger = v.trigger();
    this.triggerId = v.triggerId();
    this.executionId = v.executionId();
    this.executionDescription = v.executionDescription();
    this.resourceIds = v.resourceIds();
    this.triggerParameters = v.triggerParameters();
    List<Message> _messages = v.messages();
    this.messages = (_messages == null) ? null : new ArrayList<Message>(_messages);
  }

  private StateDataBuilder(StateDataBuilder v) {
    this.tries = v.tries;
    this.consecutiveFailures = v.consecutiveFailures;
    this.retryCost = v.retryCost;
    this.retryDelayMillis = v.retryDelayMillis;
    this.lastExit = v.lastExit;
    this.trigger = v.trigger;
    this.triggerId = v.triggerId;
    this.executionId = v.executionId;
    this.executionDescription = v.executionDescription;
    this.resourceIds = v.resourceIds;
    this.triggerParameters = v.triggerParameters;
    this.messages = (v.messages == null) ? null : new ArrayList<Message>(v.messages);
  }

  public int tries() {
    return tries;
  }

  public StateDataBuilder tries(int tries) {
    this.tries = tries;
    return this;
  }

  public int consecutiveFailures() {
    return consecutiveFailures;
  }

  public StateDataBuilder consecutiveFailures(int consecutiveFailures) {
    this.consecutiveFailures = consecutiveFailures;
    return this;
  }

  public double retryCost() {
    return retryCost;
  }

  public StateDataBuilder retryCost(double retryCost) {
    this.retryCost = retryCost;
    return this;
  }

  public Optional<Long> retryDelayMillis() {
    return retryDelayMillis;
  }

  public StateDataBuilder retryDelayMillis(Long retryDelayMillis) {
    return retryDelayMillis(Optional.ofNullable(retryDelayMillis));
  }

  @SuppressWarnings("unchecked")
  public StateDataBuilder retryDelayMillis(Optional<? extends Long> retryDelayMillis) {
    if (retryDelayMillis == null) {
      throw new NullPointerException("retryDelayMillis");
    }
    this.retryDelayMillis = (Optional<Long>)retryDelayMillis;
    return this;
  }

  public Optional<Integer> lastExit() {
    return lastExit;
  }

  public StateDataBuilder lastExit(Integer lastExit) {
    return lastExit(Optional.ofNullable(lastExit));
  }

  @SuppressWarnings("unchecked")
  public StateDataBuilder lastExit(Optional<? extends Integer> lastExit) {
    if (lastExit == null) {
      throw new NullPointerException("lastExit");
    }
    this.lastExit = (Optional<Integer>)lastExit;
    return this;
  }

  public Optional<Trigger> trigger() {
    return trigger;
  }

  public StateDataBuilder trigger(Trigger trigger) {
    return trigger(Optional.ofNullable(trigger));
  }

  @SuppressWarnings("unchecked")
  public StateDataBuilder trigger(Optional<? extends Trigger> trigger) {
    if (trigger == null) {
      throw new NullPointerException("trigger");
    }
    this.trigger = (Optional<Trigger>)trigger;
    return this;
  }

  public Optional<String> triggerId() {
    return triggerId;
  }

  public StateDataBuilder triggerId(String triggerId) {
    return triggerId(Optional.ofNullable(triggerId));
  }

  @SuppressWarnings("unchecked")
  public StateDataBuilder triggerId(Optional<? extends String> triggerId) {
    if (triggerId == null) {
      throw new NullPointerException("triggerId");
    }
    this.triggerId = (Optional<String>)triggerId;
    return this;
  }

  public Optional<String> executionId() {
    return executionId;
  }

  public StateDataBuilder executionId(String executionId) {
    return executionId(Optional.ofNullable(executionId));
  }

  @SuppressWarnings("unchecked")
  public StateDataBuilder executionId(Optional<? extends String> executionId) {
    if (executionId == null) {
      throw new NullPointerException("executionId");
    }
    this.executionId = (Optional<String>)executionId;
    return this;
  }

  public Optional<ExecutionDescription> executionDescription() {
    return executionDescription;
  }

  public StateDataBuilder executionDescription(ExecutionDescription executionDescription) {
    return executionDescription(Optional.ofNullable(executionDescription));
  }

  @SuppressWarnings("unchecked")
  public StateDataBuilder executionDescription(
      Optional<? extends ExecutionDescription> executionDescription) {
    if (executionDescription == null) {
      throw new NullPointerException("executionDescription");
    }
    this.executionDescription = (Optional<ExecutionDescription>)executionDescription;
    return this;
  }

  public Optional<Set<String>> resourceIds() {
    return resourceIds;
  }

  public StateDataBuilder resourceIds(Set<String> resourceIds) {
    return resourceIds(Optional.ofNullable(resourceIds));
  }

  @SuppressWarnings("unchecked")
  public StateDataBuilder resourceIds(Optional<? extends Set<String>> resourceIds) {
    if (resourceIds == null) {
      throw new NullPointerException("resourceIds");
    }
    this.resourceIds = (Optional<Set<String>>)resourceIds;
    return this;
  }

  public Optional<TriggerParameters> triggerParameters() {
    return triggerParameters;
  }

  public StateDataBuilder triggerParameters(TriggerParameters triggerParameters) {
    return triggerParameters(Optional.ofNullable(triggerParameters));
  }

  @SuppressWarnings("unchecked")
  public StateDataBuilder triggerParameters(
      Optional<? extends TriggerParameters> triggerParameters) {
    if (triggerParameters == null) {
      throw new NullPointerException("triggerParameters");
    }
    this.triggerParameters = (Optional<TriggerParameters>)triggerParameters;
    return this;
  }

  public List<Message> messages() {
    if (this.messages == null) {
      this.messages = new ArrayList<Message>();
    }
    return messages;
  }

  public StateDataBuilder messages(List<? extends Message> messages) {
    return messages((Collection<? extends Message>) messages);
  }

  public StateDataBuilder messages(Collection<? extends Message> messages) {
    if (messages == null) {
      throw new NullPointerException("messages");
    }
    for (Message item : messages) {
      if (item == null) {
        throw new NullPointerException("messages: null item");
      }
    }
    this.messages = new ArrayList<Message>(messages);
    return this;
  }

  public StateDataBuilder messages(Iterable<? extends Message> messages) {
    if (messages == null) {
      throw new NullPointerException("messages");
    }
    if (messages instanceof Collection) {
      return messages((Collection<? extends Message>) messages);
    }
    return messages(messages.iterator());
  }

  public StateDataBuilder messages(Iterator<? extends Message> messages) {
    if (messages == null) {
      throw new NullPointerException("messages");
    }
    this.messages = new ArrayList<Message>();
    while (messages.hasNext()) {
      Message item = messages.next();
      if (item == null) {
        throw new NullPointerException("messages: null item");
      }
      this.messages.add(item);
    }
    return this;
  }

  @SafeVarargs
  public final StateDataBuilder messages(Message... messages) {
    if (messages == null) {
      throw new NullPointerException("messages");
    }
    return messages(Arrays.asList(messages));
  }

  public StateDataBuilder addMessage(Message message) {
    if (message == null) {
      throw new NullPointerException("message");
    }
    if (this.messages == null) {
      this.messages = new ArrayList<Message>();
    }
    messages.add(message);
    return this;
  }

  public StateDataBuilder builder() {
    return new StateDataBuilder(this);
  }

  public StateData build() {
    List<Message> _messages = (messages != null) ? Collections.unmodifiableList(new ArrayList<Message>(messages)) : Collections.<Message>emptyList();
    return new Value(tries, consecutiveFailures, retryCost, retryDelayMillis, lastExit, trigger, triggerId, executionId, executionDescription, resourceIds, triggerParameters, _messages);
  }

  public static StateDataBuilder from(StateData v) {
    return new StateDataBuilder(v);
  }

  public static StateDataBuilder from(StateDataBuilder v) {
    return new StateDataBuilder(v);
  }

  private static final class Value implements StateData {
    private final int tries;

    private final int consecutiveFailures;

    private final double retryCost;

    private final Optional<Long> retryDelayMillis;

    private final Optional<Integer> lastExit;

    private final Optional<Trigger> trigger;

    private final Optional<String> triggerId;

    private final Optional<String> executionId;

    private final Optional<ExecutionDescription> executionDescription;

    private final Optional<Set<String>> resourceIds;

    private final Optional<TriggerParameters> triggerParameters;

    private final List<Message> messages;

    private Value(@AutoMatter.Field("tries") int tries,
        @AutoMatter.Field("consecutiveFailures") int consecutiveFailures,
        @AutoMatter.Field("retryCost") double retryCost,
        @AutoMatter.Field("retryDelayMillis") Optional<Long> retryDelayMillis,
        @AutoMatter.Field("lastExit") Optional<Integer> lastExit,
        @AutoMatter.Field("trigger") Optional<Trigger> trigger,
        @AutoMatter.Field("triggerId") Optional<String> triggerId,
        @AutoMatter.Field("executionId") Optional<String> executionId,
        @AutoMatter.Field("executionDescription") Optional<ExecutionDescription> executionDescription,
        @AutoMatter.Field("resourceIds") Optional<Set<String>> resourceIds,
        @AutoMatter.Field("triggerParameters") Optional<TriggerParameters> triggerParameters,
        @AutoMatter.Field("messages") List<Message> messages) {
      if (retryDelayMillis == null) {
        throw new NullPointerException("retryDelayMillis");
      }
      if (lastExit == null) {
        throw new NullPointerException("lastExit");
      }
      if (trigger == null) {
        throw new NullPointerException("trigger");
      }
      if (triggerId == null) {
        throw new NullPointerException("triggerId");
      }
      if (executionId == null) {
        throw new NullPointerException("executionId");
      }
      if (executionDescription == null) {
        throw new NullPointerException("executionDescription");
      }
      if (resourceIds == null) {
        throw new NullPointerException("resourceIds");
      }
      if (triggerParameters == null) {
        throw new NullPointerException("triggerParameters");
      }
      this.tries = tries;
      this.consecutiveFailures = consecutiveFailures;
      this.retryCost = retryCost;
      this.retryDelayMillis = retryDelayMillis;
      this.lastExit = lastExit;
      this.trigger = trigger;
      this.triggerId = triggerId;
      this.executionId = executionId;
      this.executionDescription = executionDescription;
      this.resourceIds = resourceIds;
      this.triggerParameters = triggerParameters;
      this.messages = (messages != null) ? messages : Collections.<Message>emptyList();
    }

    @AutoMatter.Field
    @Override
    public int tries() {
      return tries;
    }

    @AutoMatter.Field
    @Override
    public int consecutiveFailures() {
      return consecutiveFailures;
    }

    @AutoMatter.Field
    @Override
    public double retryCost() {
      return retryCost;
    }

    @AutoMatter.Field
    @Override
    public Optional<Long> retryDelayMillis() {
      return retryDelayMillis;
    }

    @AutoMatter.Field
    @Override
    public Optional<Integer> lastExit() {
      return lastExit;
    }

    @AutoMatter.Field
    @Override
    public Optional<Trigger> trigger() {
      return trigger;
    }

    @AutoMatter.Field
    @Override
    public Optional<String> triggerId() {
      return triggerId;
    }

    @AutoMatter.Field
    @Override
    public Optional<String> executionId() {
      return executionId;
    }

    @AutoMatter.Field
    @Override
    public Optional<ExecutionDescription> executionDescription() {
      return executionDescription;
    }

    @AutoMatter.Field
    @Override
    public Optional<Set<String>> resourceIds() {
      return resourceIds;
    }

    @AutoMatter.Field
    @Override
    public Optional<TriggerParameters> triggerParameters() {
      return triggerParameters;
    }

    @AutoMatter.Field
    @Override
    public List<Message> messages() {
      return messages;
    }

    @Override
    public StateDataBuilder builder() {
      return new StateDataBuilder(this);
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (!(o instanceof StateData)) {
        return false;
      }
      final StateData that = (StateData) o;
      if (tries != that.tries()) {
        return false;
      }
      if (consecutiveFailures != that.consecutiveFailures()) {
        return false;
      }
      if (Double.compare(retryCost, that.retryCost()) != 0) {
        return false;
      }
      if (retryDelayMillis != null ? !retryDelayMillis.equals(that.retryDelayMillis()) : that.retryDelayMillis() != null) {
        return false;
      }
      if (lastExit != null ? !lastExit.equals(that.lastExit()) : that.lastExit() != null) {
        return false;
      }
      if (trigger != null ? !trigger.equals(that.trigger()) : that.trigger() != null) {
        return false;
      }
      if (triggerId != null ? !triggerId.equals(that.triggerId()) : that.triggerId() != null) {
        return false;
      }
      if (executionId != null ? !executionId.equals(that.executionId()) : that.executionId() != null) {
        return false;
      }
      if (executionDescription != null ? !executionDescription.equals(that.executionDescription()) : that.executionDescription() != null) {
        return false;
      }
      if (resourceIds != null ? !resourceIds.equals(that.resourceIds()) : that.resourceIds() != null) {
        return false;
      }
      if (triggerParameters != null ? !triggerParameters.equals(that.triggerParameters()) : that.triggerParameters() != null) {
        return false;
      }
      if (messages != null ? !messages.equals(that.messages()) : that.messages() != null) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      long temp;
      result = 31 * result + this.tries;
      result = 31 * result + this.consecutiveFailures;
      temp = Double.doubleToLongBits(this.retryCost);
      result = 31 * result + (int) (temp ^ (temp >>> 32));
      result = 31 * result + (this.retryDelayMillis != null ? this.retryDelayMillis.hashCode() : 0);
      result = 31 * result + (this.lastExit != null ? this.lastExit.hashCode() : 0);
      result = 31 * result + (this.trigger != null ? this.trigger.hashCode() : 0);
      result = 31 * result + (this.triggerId != null ? this.triggerId.hashCode() : 0);
      result = 31 * result + (this.executionId != null ? this.executionId.hashCode() : 0);
      result = 31 * result + (this.executionDescription != null ? this.executionDescription.hashCode() : 0);
      result = 31 * result + (this.resourceIds != null ? this.resourceIds.hashCode() : 0);
      result = 31 * result + (this.triggerParameters != null ? this.triggerParameters.hashCode() : 0);
      result = 31 * result + (this.messages != null ? this.messages.hashCode() : 0);
      return result;
    }

    @Override
    public String toString() {
      return "StateData{" +
      "tries=" + tries +
      ", consecutiveFailures=" + consecutiveFailures +
      ", retryCost=" + retryCost +
      ", retryDelayMillis=" + retryDelayMillis +
      ", lastExit=" + lastExit +
      ", trigger=" + trigger +
      ", triggerId=" + triggerId +
      ", executionId=" + executionId +
      ", executionDescription=" + executionDescription +
      ", resourceIds=" + resourceIds +
      ", triggerParameters=" + triggerParameters +
      ", messages=" + messages +
      '}';
    }
  }
}
