/*-
 * -\-\-
 * Spotify Styx Common
 * --
 * Copyright (C) 2016 - 2018 Spotify AB
 * --
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * -/-/-
 */

package com.spotify.styx.util;


import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;

/**
 * A value for a single shard of {@link ShardedCounter}.
 */
@AutoValue
public abstract class Shard {

  @JsonProperty
  public abstract String counterId();

  @JsonProperty
  public abstract int index();

  @JsonProperty
  public abstract int value();

  @JsonCreator
  public static Shard create(@JsonProperty("counter_id") String counterId,
                             @JsonProperty("index") int index,
                             @JsonProperty("value") int value) {
    return new AutoValue_Shard(counterId, index, value);
  }
}
