/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.api;

import com.spotify.apollo.Response;
import com.spotify.apollo.route.AsyncHandler;
import com.spotify.apollo.route.Route;
import com.spotify.styx.api.Middlewares;
import com.spotify.styx.api.RequestAuthenticator;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import okio.ByteString;

public final class Api {
    private static final Tracer tracer = Tracing.getTracer();

    private Api() {
        throw new UnsupportedOperationException();
    }

    public static Stream<Route<AsyncHandler<Response<ByteString>>>> prefixRoutes(Collection<Route<AsyncHandler<Response<ByteString>>>> routes, Version ... versions) {
        return Stream.of(versions).flatMap(v -> routes.stream().map(route -> route.withPrefix(v.prefix())));
    }

    public static Stream<Route<AsyncHandler<Response<ByteString>>>> withCommonMiddleware(Stream<Route<AsyncHandler<Response<ByteString>>>> routes, RequestAuthenticator authenticator, String service) {
        return Api.withCommonMiddleware(routes, Collections::emptyList, authenticator, service);
    }

    public static Stream<Route<AsyncHandler<Response<ByteString>>>> withCommonMiddleware(Stream<Route<AsyncHandler<Response<ByteString>>>> routes, Supplier<List<String>> clientBlacklistSupplier, RequestAuthenticator authenticator, String service) {
        return routes.map(r -> r.withMiddleware(Middlewares.httpLogger(authenticator)).withMiddleware(Middlewares.authenticator(authenticator)).withMiddleware(Middlewares.clientValidator(clientBlacklistSupplier)).withMiddleware(Middlewares.exceptionAndRequestIdHandler()).withMiddleware(Middlewares.tracer(tracer, service)));
    }

    public static enum Version {
        V3;


        public String prefix() {
            return "/api/" + this.name().toLowerCase();
        }
    }
}

