/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.api;

import com.google.api.services.cloudresourcemanager.model.ResourceId;
import com.spotify.styx.api.AuthenticatorConfigurationBuilder;
import com.typesafe.config.Config;
import io.norberg.automatter.AutoMatter;
import java.util.Set;
import java.util.stream.Collectors;

@AutoMatter
public interface AuthenticatorConfiguration {
    public Set<String> domainWhitelist();

    public Set<ResourceId> resourceWhitelist();

    public String service();

    public static AuthenticatorConfigurationBuilder builder() {
        return new AuthenticatorConfigurationBuilder();
    }

    public static AuthenticatorConfiguration fromConfig(Config config, String serviceName) {
        String domainWhitelistKey = "styx.authentication.domain-whitelist";
        String resourceWhitelistKey = "styx.authentication.resource-whitelist";
        AuthenticatorConfigurationBuilder builder = AuthenticatorConfiguration.builder().service(serviceName);
        if (config.hasPath("styx.authentication.domain-whitelist")) {
            builder.domainWhitelist(config.getStringList("styx.authentication.domain-whitelist"));
        }
        if (config.hasPath("styx.authentication.resource-whitelist")) {
            builder.resourceWhitelist(config.getConfigList("styx.authentication.resource-whitelist").stream().map(item -> new ResourceId().setType(item.getString("type")).setId(item.getString("id"))).collect(Collectors.toSet()));
        }
        return builder.build();
    }
}

