/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.api;

import com.google.api.services.cloudresourcemanager.model.ResourceId;
import com.spotify.styx.api.AuthenticatorConfiguration;
import io.norberg.automatter.AutoMatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class AuthenticatorConfigurationBuilder {
    private Set<String> domainWhitelist;
    private Set<ResourceId> resourceWhitelist;
    private String service;

    public AuthenticatorConfigurationBuilder() {
    }

    private AuthenticatorConfigurationBuilder(AuthenticatorConfiguration v) {
        Set<String> _domainWhitelist = v.domainWhitelist();
        this.domainWhitelist = _domainWhitelist == null ? null : new HashSet<String>(_domainWhitelist);
        Set<ResourceId> _resourceWhitelist = v.resourceWhitelist();
        this.resourceWhitelist = _resourceWhitelist == null ? null : new HashSet<ResourceId>(_resourceWhitelist);
        this.service = v.service();
    }

    private AuthenticatorConfigurationBuilder(AuthenticatorConfigurationBuilder v) {
        this.domainWhitelist = v.domainWhitelist == null ? null : new HashSet<String>(v.domainWhitelist);
        this.resourceWhitelist = v.resourceWhitelist == null ? null : new HashSet<ResourceId>(v.resourceWhitelist);
        this.service = v.service;
    }

    public Set<String> domainWhitelist() {
        if (this.domainWhitelist == null) {
            this.domainWhitelist = new HashSet<String>();
        }
        return this.domainWhitelist;
    }

    public AuthenticatorConfigurationBuilder domainWhitelist(Set<? extends String> domainWhitelist) {
        return this.domainWhitelist((Collection<? extends String>)domainWhitelist);
    }

    public AuthenticatorConfigurationBuilder domainWhitelist(Collection<? extends String> domainWhitelist) {
        if (domainWhitelist == null) {
            throw new NullPointerException("domainWhitelist");
        }
        for (String string : domainWhitelist) {
            if (string != null) continue;
            throw new NullPointerException("domainWhitelist: null item");
        }
        this.domainWhitelist = new HashSet<String>(domainWhitelist);
        return this;
    }

    public AuthenticatorConfigurationBuilder domainWhitelist(Iterable<? extends String> domainWhitelist) {
        if (domainWhitelist == null) {
            throw new NullPointerException("domainWhitelist");
        }
        if (domainWhitelist instanceof Collection) {
            return this.domainWhitelist((Collection)domainWhitelist);
        }
        return this.domainWhitelist(domainWhitelist.iterator());
    }

    public AuthenticatorConfigurationBuilder domainWhitelist(Iterator<? extends String> domainWhitelist) {
        if (domainWhitelist == null) {
            throw new NullPointerException("domainWhitelist");
        }
        this.domainWhitelist = new HashSet<String>();
        while (domainWhitelist.hasNext()) {
            String item = domainWhitelist.next();
            if (item == null) {
                throw new NullPointerException("domainWhitelist: null item");
            }
            this.domainWhitelist.add(item);
        }
        return this;
    }

    @SafeVarargs
    public final AuthenticatorConfigurationBuilder domainWhitelist(String ... domainWhitelist) {
        if (domainWhitelist == null) {
            throw new NullPointerException("domainWhitelist");
        }
        return this.domainWhitelist((Collection<? extends String>)Arrays.asList(domainWhitelist));
    }

    public Set<ResourceId> resourceWhitelist() {
        if (this.resourceWhitelist == null) {
            this.resourceWhitelist = new HashSet<ResourceId>();
        }
        return this.resourceWhitelist;
    }

    public AuthenticatorConfigurationBuilder resourceWhitelist(Set<? extends ResourceId> resourceWhitelist) {
        return this.resourceWhitelist((Collection<? extends ResourceId>)resourceWhitelist);
    }

    public AuthenticatorConfigurationBuilder resourceWhitelist(Collection<? extends ResourceId> resourceWhitelist) {
        if (resourceWhitelist == null) {
            throw new NullPointerException("resourceWhitelist");
        }
        for (ResourceId resourceId : resourceWhitelist) {
            if (resourceId != null) continue;
            throw new NullPointerException("resourceWhitelist: null item");
        }
        this.resourceWhitelist = new HashSet<ResourceId>(resourceWhitelist);
        return this;
    }

    public AuthenticatorConfigurationBuilder resourceWhitelist(Iterable<? extends ResourceId> resourceWhitelist) {
        if (resourceWhitelist == null) {
            throw new NullPointerException("resourceWhitelist");
        }
        if (resourceWhitelist instanceof Collection) {
            return this.resourceWhitelist((Collection)resourceWhitelist);
        }
        return this.resourceWhitelist(resourceWhitelist.iterator());
    }

    public AuthenticatorConfigurationBuilder resourceWhitelist(Iterator<? extends ResourceId> resourceWhitelist) {
        if (resourceWhitelist == null) {
            throw new NullPointerException("resourceWhitelist");
        }
        this.resourceWhitelist = new HashSet<ResourceId>();
        while (resourceWhitelist.hasNext()) {
            ResourceId item = resourceWhitelist.next();
            if (item == null) {
                throw new NullPointerException("resourceWhitelist: null item");
            }
            this.resourceWhitelist.add(item);
        }
        return this;
    }

    @SafeVarargs
    public final AuthenticatorConfigurationBuilder resourceWhitelist(ResourceId ... resourceWhitelist) {
        if (resourceWhitelist == null) {
            throw new NullPointerException("resourceWhitelist");
        }
        return this.resourceWhitelist((Collection<? extends ResourceId>)Arrays.asList(resourceWhitelist));
    }

    public String service() {
        return this.service;
    }

    public AuthenticatorConfigurationBuilder service(String service) {
        if (service == null) {
            throw new NullPointerException("service");
        }
        this.service = service;
        return this;
    }

    public AuthenticatorConfiguration build() {
        Set _domainWhitelist = this.domainWhitelist != null ? Collections.unmodifiableSet(new HashSet<String>(this.domainWhitelist)) : Collections.emptySet();
        Set _resourceWhitelist = this.resourceWhitelist != null ? Collections.unmodifiableSet(new HashSet<ResourceId>(this.resourceWhitelist)) : Collections.emptySet();
        return new Value(_domainWhitelist, _resourceWhitelist, this.service);
    }

    public static AuthenticatorConfigurationBuilder from(AuthenticatorConfiguration v) {
        return new AuthenticatorConfigurationBuilder(v);
    }

    public static AuthenticatorConfigurationBuilder from(AuthenticatorConfigurationBuilder v) {
        return new AuthenticatorConfigurationBuilder(v);
    }

    private static final class Value
    implements AuthenticatorConfiguration {
        private final Set<String> domainWhitelist;
        private final Set<ResourceId> resourceWhitelist;
        private final String service;

        private Value(@AutoMatter.Field(value="domainWhitelist") Set<String> domainWhitelist, @AutoMatter.Field(value="resourceWhitelist") Set<ResourceId> resourceWhitelist, @AutoMatter.Field(value="service") String service) {
            if (service == null) {
                throw new NullPointerException("service");
            }
            this.domainWhitelist = domainWhitelist != null ? domainWhitelist : Collections.emptySet();
            this.resourceWhitelist = resourceWhitelist != null ? resourceWhitelist : Collections.emptySet();
            this.service = service;
        }

        @Override
        @AutoMatter.Field
        public Set<String> domainWhitelist() {
            return this.domainWhitelist;
        }

        @Override
        @AutoMatter.Field
        public Set<ResourceId> resourceWhitelist() {
            return this.resourceWhitelist;
        }

        @Override
        @AutoMatter.Field
        public String service() {
            return this.service;
        }

        @Override
        public AuthenticatorConfigurationBuilder builder() {
            return new AuthenticatorConfigurationBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AuthenticatorConfiguration)) {
                return false;
            }
            AuthenticatorConfiguration that = (AuthenticatorConfiguration)o;
            if (this.domainWhitelist != null ? !this.domainWhitelist.equals(that.domainWhitelist()) : that.domainWhitelist() != null) {
                return false;
            }
            if (this.resourceWhitelist != null ? !this.resourceWhitelist.equals(that.resourceWhitelist()) : that.resourceWhitelist() != null) {
                return false;
            }
            return !(this.service != null ? !this.service.equals(that.service()) : that.service() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.domainWhitelist != null ? this.domainWhitelist.hashCode() : 0);
            result = 31 * result + (this.resourceWhitelist != null ? this.resourceWhitelist.hashCode() : 0);
            result = 31 * result + (this.service != null ? this.service.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "AuthenticatorConfiguration{domainWhitelist=" + this.domainWhitelist + ", resourceWhitelist=" + this.resourceWhitelist + ", service=" + this.service + '}';
        }
    }
}

