/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.api;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.auth.oauth2.GoogleIdTokenVerifier;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.googleapis.util.Utils;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.services.cloudresourcemanager.CloudResourceManager;
import com.google.api.services.iam.v1.Iam;
import com.google.api.services.iam.v1.IamScopes;
import com.google.common.annotations.VisibleForTesting;
import com.spotify.styx.api.Authenticator;
import com.spotify.styx.api.AuthenticatorConfiguration;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.function.Function;

public interface AuthenticatorFactory
extends Function<AuthenticatorConfiguration, Authenticator> {
    public static final AuthenticatorFactory DEFAULT = new DefaultAuthenticatorFactory();

    public static class DefaultAuthenticatorFactory
    implements AuthenticatorFactory {
        @VisibleForTesting
        GoogleIdTokenVerifier buildGoogleIdTokenVerifier(HttpTransport httpTransport, JsonFactory jsonFactory) {
            return new GoogleIdTokenVerifier(httpTransport, jsonFactory);
        }

        @VisibleForTesting
        GoogleCredential loadCredential() {
            try {
                return GoogleCredential.getApplicationDefault().createScoped((Collection)IamScopes.all());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @VisibleForTesting
        Iam buildIam(HttpTransport httpTransport, JsonFactory jsonFactory, GoogleCredential credential, String service) {
            return new Iam.Builder(httpTransport, jsonFactory, (HttpRequestInitializer)credential).setApplicationName(service).build();
        }

        @VisibleForTesting
        CloudResourceManager buildCloudResourceManager(HttpTransport httpTransport, JsonFactory jsonFactory, GoogleCredential credential, String service) {
            return new CloudResourceManager.Builder(httpTransport, jsonFactory, (HttpRequestInitializer)credential).setApplicationName(service).build();
        }

        @Override
        public Authenticator apply(AuthenticatorConfiguration configuration) {
            NetHttpTransport httpTransport;
            try {
                httpTransport = GoogleNetHttpTransport.newTrustedTransport();
            }
            catch (IOException | GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
            JsonFactory jsonFactory = Utils.getDefaultJsonFactory();
            GoogleIdTokenVerifier googleIdTokenVerifier = this.buildGoogleIdTokenVerifier((HttpTransport)httpTransport, jsonFactory);
            GoogleCredential credential = this.loadCredential();
            CloudResourceManager cloudResourceManager = this.buildCloudResourceManager((HttpTransport)httpTransport, jsonFactory, credential, configuration.service());
            Iam iam = this.buildIam((HttpTransport)httpTransport, jsonFactory, credential, configuration.service());
            Authenticator validator = new Authenticator(googleIdTokenVerifier, cloudResourceManager, iam, configuration);
            try {
                validator.cacheResources();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return validator;
        }
    }
}

