/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.api.client.googleapis.auth.oauth2.GoogleIdToken;
import com.google.common.base.CharMatcher;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.spotify.apollo.Request;
import com.spotify.apollo.RequestContext;
import com.spotify.apollo.Response;
import com.spotify.apollo.Status;
import com.spotify.apollo.StatusType;
import com.spotify.apollo.route.AsyncHandler;
import com.spotify.apollo.route.Middleware;
import com.spotify.apollo.route.SyncHandler;
import com.spotify.styx.api.RequestAuthenticator;
import com.spotify.styx.api.ResponseException;
import com.spotify.styx.serialization.Json;
import com.spotify.styx.util.MDCUtil;
import io.norberg.automatter.AutoMatter;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Span;
import io.opencensus.trace.Tracer;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public final class Middlewares {
    private static final Logger LOG = LoggerFactory.getLogger(Middlewares.class);
    private static final Set<String> BLACKLISTED_HEADERS = ImmutableSet.of((Object)"Authorization");
    private static final String REQUEST_ID = "request-id";
    private static final String X_REQUEST_ID = "X-Request-Id";

    private Middlewares() {
        throw new UnsupportedOperationException();
    }

    public static Middleware<SyncHandler<? extends Response<?>>, AsyncHandler<Response<ByteString>>> json() {
        return innerHandler -> (AsyncHandler)Middlewares.jsonAsync().apply((Object)Middleware.syncToAsync((SyncHandler)innerHandler));
    }

    public static Middleware<AsyncHandler<? extends Response<?>>, AsyncHandler<Response<ByteString>>> jsonAsync() {
        return innerHandler -> innerHandler.map(response -> {
            if (!response.payload().isPresent()) {
                return response;
            }
            Object tPayload = response.payload().get();
            try {
                byte[] bytes = Json.OBJECT_MAPPER.writeValueAsBytes(tPayload);
                ByteString payload = ByteString.of((byte[])bytes);
                return response.withPayload((Object)payload).withHeader("Content-Type", "application/json");
            }
            catch (JsonProcessingException e) {
                return Response.forStatus((StatusType)Status.INTERNAL_SERVER_ERROR.withReasonPhrase("Failed to serialize response " + e.getMessage()));
            }
        });
    }

    public static <T> Middleware<AsyncHandler<Response<T>>, AsyncHandler<Response<T>>> clientValidator(Supplier<List<String>> supplier) {
        return innerHandler -> arg_0 -> Middlewares.lambda$clientValidator$4((Supplier)supplier, innerHandler, arg_0);
    }

    public static <T> Middleware<AsyncHandler<Response<T>>, AsyncHandler<Response<T>>> exceptionAndRequestIdHandler() {
        return innerHandler -> requestContext -> {
            String requestIdHeader = (String)requestContext.request().headers().get(X_REQUEST_ID);
            String requestId = requestIdHeader != null ? requestIdHeader : UUID.randomUUID().toString().replace("-", "");
            try (MDC.MDCCloseable mdc = MDCUtil.safePutCloseable(REQUEST_ID, requestId);){
                CompletionStage<Response> completionStage = innerHandler.invoke(requestContext).handle((r, t) -> {
                    Response response = t != null ? (t instanceof ResponseException ? ((ResponseException)t).getResponse() : Response.forStatus((StatusType)Status.INTERNAL_SERVER_ERROR.withReasonPhrase(Middlewares.internalServerErrorReason(requestId, t)))) : r;
                    return response.withHeader(X_REQUEST_ID, requestId);
                });
                return completionStage;
            }
            catch (ResponseException e) {
                return CompletableFuture.completedFuture(e.getResponse().withHeader(X_REQUEST_ID, requestId));
            }
            catch (Throwable t2) {
                return CompletableFuture.completedFuture(Response.forStatus((StatusType)Status.INTERNAL_SERVER_ERROR.withReasonPhrase(Middlewares.internalServerErrorReason(requestId, t2))).withHeader(X_REQUEST_ID, requestId));
            }
        };
    }

    private static String internalServerErrorReason(String requestId, Throwable t) {
        StringBuilder reason = new StringBuilder(Status.INTERNAL_SERVER_ERROR.reasonPhrase()).append(" (").append("Request ID: ").append(requestId).append(")").append(": ").append(t.getClass().getSimpleName()).append(": ").append(t.getMessage());
        Throwable rootCause = Throwables.getRootCause((Throwable)t);
        if (!t.equals(rootCause)) {
            reason.append(": ").append(rootCause.getClass().getSimpleName()).append(": ").append(rootCause.getMessage());
        }
        return CharMatcher.anyOf((CharSequence)"\n\r").replaceFrom((CharSequence)reason.toString(), ' ');
    }

    public static <T> Middleware<AsyncHandler<Response<T>>, AsyncHandler<Response<T>>> httpLogger(RequestAuthenticator authenticator) {
        return Middlewares.httpLogger(LOG, authenticator);
    }

    public static <T> Middleware<AsyncHandler<Response<T>>, AsyncHandler<Response<T>>> httpLogger(Logger log, RequestAuthenticator authenticator) {
        return innerHandler -> requestContext -> {
            Request request = requestContext.request();
            log.info("{}{} {} by {} with headers {} parameters {} and payload {}", new Object[]{"GET".equals(request.method()) ? "" : "[AUDIT] ", request.method(), request.uri(), Middlewares.auth(requestContext, authenticator).user().map(idToken -> idToken.getPayload().getEmail()).orElse("anonymous"), Middlewares.hideSensitiveHeaders(request.headers()), request.parameters(), request.payload().map(ByteString::utf8).orElse("").replaceAll("\n", " ")});
            return innerHandler.invoke(requestContext);
        };
    }

    public static <T> Middleware<AsyncHandler<Response<T>>, AsyncHandler<Response<T>>> tracer(Tracer tracer, String service) {
        return innerHandler -> requestContext -> {
            CompletionStage response;
            Request request = requestContext.request();
            URI uri = URI.create(request.uri());
            Span span = tracer.spanBuilder(service + '/' + uri.getPath()).startSpan();
            span.putAttribute("method", AttributeValue.stringAttributeValue((String)request.method()));
            span.putAttribute("uri", AttributeValue.stringAttributeValue((String)request.uri()));
            try {
                response = innerHandler.invoke(requestContext);
            }
            catch (Exception e) {
                span.setStatus(io.opencensus.trace.Status.UNKNOWN);
                span.end();
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
            response.whenComplete((r, ex) -> {
                if (ex != null) {
                    span.setStatus(io.opencensus.trace.Status.UNKNOWN);
                }
                span.end();
            });
            return response;
        };
    }

    public static Middleware<Requested<Authenticated<Response<?>>>, AsyncHandler<Response<ByteString>>> authed(RequestAuthenticator authenticator) {
        return ar -> (AsyncHandler)Middlewares.jsonAsync().apply(requestContext -> {
            Response payload = (Response)((Authenticated)ar.apply(requestContext)).apply(Middlewares.auth(requestContext, authenticator));
            return CompletableFuture.completedFuture(payload);
        });
    }

    private static AuthContext auth(RequestContext requestContext, RequestAuthenticator authenticator) {
        return authenticator.authenticate(requestContext.request());
    }

    private static Map<String, String> hideSensitiveHeaders(Map<String, String> headers) {
        return headers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> BLACKLISTED_HEADERS.contains(entry.getKey()) ? "<hidden>" : (String)entry.getValue()));
    }

    public static <T> Middleware<AsyncHandler<Response<T>>, AsyncHandler<Response<T>>> authenticator(RequestAuthenticator authenticator) {
        return h -> rc -> {
            Optional<GoogleIdToken> idToken = Middlewares.auth(rc, authenticator).user();
            if (!"GET".equals(rc.request().method()) && !idToken.isPresent()) {
                return CompletableFuture.completedFuture(Response.forStatus((StatusType)Status.UNAUTHORIZED.withReasonPhrase("Unauthorized access")));
            }
            return h.invoke(rc);
        };
    }

    private static /* synthetic */ CompletionStage lambda$clientValidator$4(Supplier supplier, AsyncHandler innerHandler, RequestContext requestContext) {
        if (requestContext.request().header("User-Agent").map(arg_0 -> Middlewares.lambda$clientValidator$3((Supplier)supplier, arg_0)).orElse(false).booleanValue()) {
            return CompletableFuture.completedFuture(Response.forStatus((StatusType)Status.NOT_ACCEPTABLE.withReasonPhrase("blacklisted client version, please upgrade")));
        }
        return innerHandler.invoke(requestContext);
    }

    private static /* synthetic */ Boolean lambda$clientValidator$3(Supplier supplier, String header) {
        return ((List)supplier.get()).contains(header);
    }

    static interface Requested<T>
    extends Function<RequestContext, T> {
    }

    static interface Authenticated<T>
    extends Function<AuthContext, T> {
    }

    @AutoMatter
    public static interface AuthContext {
        public Optional<GoogleIdToken> user();
    }
}

