/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.api;

import com.google.api.client.googleapis.auth.oauth2.GoogleIdToken;
import com.spotify.apollo.Request;
import com.spotify.apollo.Response;
import com.spotify.apollo.Status;
import com.spotify.apollo.StatusType;
import com.spotify.styx.api.Authenticator;
import com.spotify.styx.api.Middlewares;
import com.spotify.styx.api.ResponseException;
import java.util.Objects;
import java.util.Optional;

public class RequestAuthenticator {
    private static final String BEARER_PREFIX = "Bearer ";
    private final Authenticator authenticator;

    public RequestAuthenticator(Authenticator authenticator) {
        this.authenticator = Objects.requireNonNull(authenticator, "authenticator");
    }

    public Middlewares.AuthContext authenticate(Request request) {
        GoogleIdToken googleIdToken;
        boolean hasAuthHeader = request.header("Authorization").isPresent();
        if (!hasAuthHeader) {
            return Optional::empty;
        }
        String authHeader = (String)request.header("Authorization").get();
        if (!authHeader.startsWith(BEARER_PREFIX)) {
            throw new ResponseException(Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("Authorization token must be of type Bearer")));
        }
        try {
            googleIdToken = this.authenticator.authenticate(authHeader.substring(BEARER_PREFIX.length()));
        }
        catch (IllegalArgumentException e) {
            throw new ResponseException(Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("Failed to parse Authorization token")), (Throwable)e);
        }
        if (googleIdToken == null) {
            throw new ResponseException(Response.forStatus((StatusType)Status.UNAUTHORIZED.withReasonPhrase("Authorization token is invalid")));
        }
        return () -> Optional.of(googleIdToken);
    }
}

