/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.model;

import com.spotify.styx.model.BackfillInput;
import com.spotify.styx.model.TriggerParameters;
import io.norberg.automatter.AutoMatter;
import java.time.Instant;
import java.util.Optional;

public final class BackfillInputBuilder {
    private Instant start;
    private Instant end;
    private String component;
    private String workflow;
    private int concurrency;
    private boolean reverse;
    private Optional<String> description;
    private Optional<TriggerParameters> triggerParameters;

    public BackfillInputBuilder() {
        this.description = Optional.empty();
        this.triggerParameters = Optional.empty();
    }

    private BackfillInputBuilder(BackfillInput v) {
        this.start = v.start();
        this.end = v.end();
        this.component = v.component();
        this.workflow = v.workflow();
        this.concurrency = v.concurrency();
        this.reverse = v.reverse();
        this.description = v.description();
        this.triggerParameters = v.triggerParameters();
    }

    private BackfillInputBuilder(BackfillInputBuilder v) {
        this.start = v.start;
        this.end = v.end;
        this.component = v.component;
        this.workflow = v.workflow;
        this.concurrency = v.concurrency;
        this.reverse = v.reverse;
        this.description = v.description;
        this.triggerParameters = v.triggerParameters;
    }

    public Instant start() {
        return this.start;
    }

    public BackfillInputBuilder start(Instant start) {
        if (start == null) {
            throw new NullPointerException("start");
        }
        this.start = start;
        return this;
    }

    public Instant end() {
        return this.end;
    }

    public BackfillInputBuilder end(Instant end) {
        if (end == null) {
            throw new NullPointerException("end");
        }
        this.end = end;
        return this;
    }

    public String component() {
        return this.component;
    }

    public BackfillInputBuilder component(String component) {
        if (component == null) {
            throw new NullPointerException("component");
        }
        this.component = component;
        return this;
    }

    public String workflow() {
        return this.workflow;
    }

    public BackfillInputBuilder workflow(String workflow) {
        if (workflow == null) {
            throw new NullPointerException("workflow");
        }
        this.workflow = workflow;
        return this;
    }

    public int concurrency() {
        return this.concurrency;
    }

    public BackfillInputBuilder concurrency(int concurrency) {
        this.concurrency = concurrency;
        return this;
    }

    public boolean reverse() {
        return this.reverse;
    }

    public BackfillInputBuilder reverse(boolean reverse) {
        this.reverse = reverse;
        return this;
    }

    public Optional<String> description() {
        return this.description;
    }

    public BackfillInputBuilder description(String description) {
        return this.description(Optional.ofNullable(description));
    }

    public BackfillInputBuilder description(Optional<? extends String> description) {
        if (description == null) {
            throw new NullPointerException("description");
        }
        this.description = description;
        return this;
    }

    public Optional<TriggerParameters> triggerParameters() {
        return this.triggerParameters;
    }

    public BackfillInputBuilder triggerParameters(TriggerParameters triggerParameters) {
        return this.triggerParameters(Optional.ofNullable(triggerParameters));
    }

    public BackfillInputBuilder triggerParameters(Optional<? extends TriggerParameters> triggerParameters) {
        if (triggerParameters == null) {
            throw new NullPointerException("triggerParameters");
        }
        this.triggerParameters = triggerParameters;
        return this;
    }

    public BackfillInputBuilder builder() {
        return new BackfillInputBuilder(this);
    }

    public BackfillInput build() {
        return new Value(this.start, this.end, this.component, this.workflow, this.concurrency, this.reverse, this.description, this.triggerParameters);
    }

    public static BackfillInputBuilder from(BackfillInput v) {
        return new BackfillInputBuilder(v);
    }

    public static BackfillInputBuilder from(BackfillInputBuilder v) {
        return new BackfillInputBuilder(v);
    }

    private static final class Value
    implements BackfillInput {
        private final Instant start;
        private final Instant end;
        private final String component;
        private final String workflow;
        private final int concurrency;
        private final boolean reverse;
        private final Optional<String> description;
        private final Optional<TriggerParameters> triggerParameters;

        private Value(@AutoMatter.Field(value="start") Instant start, @AutoMatter.Field(value="end") Instant end, @AutoMatter.Field(value="component") String component, @AutoMatter.Field(value="workflow") String workflow, @AutoMatter.Field(value="concurrency") int concurrency, @AutoMatter.Field(value="reverse") boolean reverse, @AutoMatter.Field(value="description") Optional<String> description, @AutoMatter.Field(value="triggerParameters") Optional<TriggerParameters> triggerParameters) {
            if (start == null) {
                throw new NullPointerException("start");
            }
            if (end == null) {
                throw new NullPointerException("end");
            }
            if (component == null) {
                throw new NullPointerException("component");
            }
            if (workflow == null) {
                throw new NullPointerException("workflow");
            }
            if (description == null) {
                throw new NullPointerException("description");
            }
            if (triggerParameters == null) {
                throw new NullPointerException("triggerParameters");
            }
            this.start = start;
            this.end = end;
            this.component = component;
            this.workflow = workflow;
            this.concurrency = concurrency;
            this.reverse = reverse;
            this.description = description;
            this.triggerParameters = triggerParameters;
        }

        @Override
        @AutoMatter.Field
        public Instant start() {
            return this.start;
        }

        @Override
        @AutoMatter.Field
        public Instant end() {
            return this.end;
        }

        @Override
        @AutoMatter.Field
        public String component() {
            return this.component;
        }

        @Override
        @AutoMatter.Field
        public String workflow() {
            return this.workflow;
        }

        @Override
        @AutoMatter.Field
        public int concurrency() {
            return this.concurrency;
        }

        @Override
        @AutoMatter.Field
        public boolean reverse() {
            return this.reverse;
        }

        @Override
        @AutoMatter.Field
        public Optional<String> description() {
            return this.description;
        }

        @Override
        @AutoMatter.Field
        public Optional<TriggerParameters> triggerParameters() {
            return this.triggerParameters;
        }

        @Override
        public BackfillInputBuilder builder() {
            return new BackfillInputBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BackfillInput)) {
                return false;
            }
            BackfillInput that = (BackfillInput)o;
            if (this.start != null ? !this.start.equals(that.start()) : that.start() != null) {
                return false;
            }
            if (this.end != null ? !this.end.equals(that.end()) : that.end() != null) {
                return false;
            }
            if (this.component != null ? !this.component.equals(that.component()) : that.component() != null) {
                return false;
            }
            if (this.workflow != null ? !this.workflow.equals(that.workflow()) : that.workflow() != null) {
                return false;
            }
            if (this.concurrency != that.concurrency()) {
                return false;
            }
            if (this.reverse != that.reverse()) {
                return false;
            }
            if (this.description != null ? !this.description.equals(that.description()) : that.description() != null) {
                return false;
            }
            return !(this.triggerParameters != null ? !this.triggerParameters.equals(that.triggerParameters()) : that.triggerParameters() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.start != null ? this.start.hashCode() : 0);
            result = 31 * result + (this.end != null ? this.end.hashCode() : 0);
            result = 31 * result + (this.component != null ? this.component.hashCode() : 0);
            result = 31 * result + (this.workflow != null ? this.workflow.hashCode() : 0);
            result = 31 * result + this.concurrency;
            result = 31 * result + (this.reverse ? 1231 : 1237);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.triggerParameters != null ? this.triggerParameters.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "BackfillInput{start=" + this.start + ", end=" + this.end + ", component=" + this.component + ", workflow=" + this.workflow + ", concurrency=" + this.concurrency + ", reverse=" + this.reverse + ", description=" + this.description + ", triggerParameters=" + this.triggerParameters + '}';
        }
    }
}

