/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.model;

import com.spotify.styx.model.EditableBackfillInput;
import io.norberg.automatter.AutoMatter;
import java.util.Optional;

public final class EditableBackfillInputBuilder {
    private String id;
    private Optional<Integer> concurrency;
    private Optional<String> description;

    public EditableBackfillInputBuilder() {
        this.concurrency = Optional.empty();
        this.description = Optional.empty();
    }

    private EditableBackfillInputBuilder(EditableBackfillInput v) {
        this.id = v.id();
        this.concurrency = v.concurrency();
        this.description = v.description();
    }

    private EditableBackfillInputBuilder(EditableBackfillInputBuilder v) {
        this.id = v.id;
        this.concurrency = v.concurrency;
        this.description = v.description;
    }

    public String id() {
        return this.id;
    }

    public EditableBackfillInputBuilder id(String id) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        this.id = id;
        return this;
    }

    public Optional<Integer> concurrency() {
        return this.concurrency;
    }

    public EditableBackfillInputBuilder concurrency(Integer concurrency) {
        return this.concurrency(Optional.ofNullable(concurrency));
    }

    public EditableBackfillInputBuilder concurrency(Optional<? extends Integer> concurrency) {
        if (concurrency == null) {
            throw new NullPointerException("concurrency");
        }
        this.concurrency = concurrency;
        return this;
    }

    public Optional<String> description() {
        return this.description;
    }

    public EditableBackfillInputBuilder description(String description) {
        return this.description(Optional.ofNullable(description));
    }

    public EditableBackfillInputBuilder description(Optional<? extends String> description) {
        if (description == null) {
            throw new NullPointerException("description");
        }
        this.description = description;
        return this;
    }

    public EditableBackfillInput build() {
        return new Value(this.id, this.concurrency, this.description);
    }

    public static EditableBackfillInputBuilder from(EditableBackfillInput v) {
        return new EditableBackfillInputBuilder(v);
    }

    public static EditableBackfillInputBuilder from(EditableBackfillInputBuilder v) {
        return new EditableBackfillInputBuilder(v);
    }

    private static final class Value
    implements EditableBackfillInput {
        private final String id;
        private final Optional<Integer> concurrency;
        private final Optional<String> description;

        private Value(@AutoMatter.Field(value="id") String id, @AutoMatter.Field(value="concurrency") Optional<Integer> concurrency, @AutoMatter.Field(value="description") Optional<String> description) {
            if (id == null) {
                throw new NullPointerException("id");
            }
            if (concurrency == null) {
                throw new NullPointerException("concurrency");
            }
            if (description == null) {
                throw new NullPointerException("description");
            }
            this.id = id;
            this.concurrency = concurrency;
            this.description = description;
        }

        @Override
        @AutoMatter.Field
        public String id() {
            return this.id;
        }

        @Override
        @AutoMatter.Field
        public Optional<Integer> concurrency() {
            return this.concurrency;
        }

        @Override
        @AutoMatter.Field
        public Optional<String> description() {
            return this.description;
        }

        public EditableBackfillInputBuilder builder() {
            return new EditableBackfillInputBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EditableBackfillInput)) {
                return false;
            }
            EditableBackfillInput that = (EditableBackfillInput)o;
            if (this.id != null ? !this.id.equals(that.id()) : that.id() != null) {
                return false;
            }
            if (this.concurrency != null ? !this.concurrency.equals(that.concurrency()) : that.concurrency() != null) {
                return false;
            }
            return !(this.description != null ? !this.description.equals(that.description()) : that.description() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            result = 31 * result + (this.concurrency != null ? this.concurrency.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "EditableBackfillInput{id=" + this.id + ", concurrency=" + this.concurrency + ", description=" + this.description + '}';
        }
    }
}

