/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.model;

import com.spotify.styx.model.StyxConfig;
import io.norberg.automatter.AutoMatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public final class StyxConfigBuilder {
    private String globalDockerRunnerId;
    private boolean globalEnabled;
    private boolean debugEnabled;
    private boolean executionGatingEnabled;
    private Optional<Long> globalConcurrency;
    private Optional<Double> submissionRateLimit;
    private List<String> clientBlacklist;

    public StyxConfigBuilder() {
        this.globalConcurrency = Optional.empty();
        this.submissionRateLimit = Optional.empty();
    }

    private StyxConfigBuilder(StyxConfig v) {
        this.globalDockerRunnerId = v.globalDockerRunnerId();
        this.globalEnabled = v.globalEnabled();
        this.debugEnabled = v.debugEnabled();
        this.executionGatingEnabled = v.executionGatingEnabled();
        this.globalConcurrency = v.globalConcurrency();
        this.submissionRateLimit = v.submissionRateLimit();
        List<String> _clientBlacklist = v.clientBlacklist();
        this.clientBlacklist = _clientBlacklist == null ? null : new ArrayList<String>(_clientBlacklist);
    }

    private StyxConfigBuilder(StyxConfigBuilder v) {
        this.globalDockerRunnerId = v.globalDockerRunnerId;
        this.globalEnabled = v.globalEnabled;
        this.debugEnabled = v.debugEnabled;
        this.executionGatingEnabled = v.executionGatingEnabled;
        this.globalConcurrency = v.globalConcurrency;
        this.submissionRateLimit = v.submissionRateLimit;
        this.clientBlacklist = v.clientBlacklist == null ? null : new ArrayList<String>(v.clientBlacklist);
    }

    public String globalDockerRunnerId() {
        return this.globalDockerRunnerId;
    }

    public StyxConfigBuilder globalDockerRunnerId(String globalDockerRunnerId) {
        if (globalDockerRunnerId == null) {
            throw new NullPointerException("globalDockerRunnerId");
        }
        this.globalDockerRunnerId = globalDockerRunnerId;
        return this;
    }

    public boolean globalEnabled() {
        return this.globalEnabled;
    }

    public StyxConfigBuilder globalEnabled(boolean globalEnabled) {
        this.globalEnabled = globalEnabled;
        return this;
    }

    public boolean debugEnabled() {
        return this.debugEnabled;
    }

    public StyxConfigBuilder debugEnabled(boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
        return this;
    }

    public boolean executionGatingEnabled() {
        return this.executionGatingEnabled;
    }

    public StyxConfigBuilder executionGatingEnabled(boolean executionGatingEnabled) {
        this.executionGatingEnabled = executionGatingEnabled;
        return this;
    }

    public Optional<Long> globalConcurrency() {
        return this.globalConcurrency;
    }

    public StyxConfigBuilder globalConcurrency(Long globalConcurrency) {
        return this.globalConcurrency(Optional.ofNullable(globalConcurrency));
    }

    public StyxConfigBuilder globalConcurrency(Optional<? extends Long> globalConcurrency) {
        if (globalConcurrency == null) {
            throw new NullPointerException("globalConcurrency");
        }
        this.globalConcurrency = globalConcurrency;
        return this;
    }

    public Optional<Double> submissionRateLimit() {
        return this.submissionRateLimit;
    }

    public StyxConfigBuilder submissionRateLimit(Double submissionRateLimit) {
        return this.submissionRateLimit(Optional.ofNullable(submissionRateLimit));
    }

    public StyxConfigBuilder submissionRateLimit(Optional<? extends Double> submissionRateLimit) {
        if (submissionRateLimit == null) {
            throw new NullPointerException("submissionRateLimit");
        }
        this.submissionRateLimit = submissionRateLimit;
        return this;
    }

    public List<String> clientBlacklist() {
        if (this.clientBlacklist == null) {
            this.clientBlacklist = new ArrayList<String>();
        }
        return this.clientBlacklist;
    }

    public StyxConfigBuilder clientBlacklist(List<? extends String> clientBlacklist) {
        return this.clientBlacklist((Collection<? extends String>)clientBlacklist);
    }

    public StyxConfigBuilder clientBlacklist(Collection<? extends String> clientBlacklist) {
        if (clientBlacklist == null) {
            throw new NullPointerException("clientBlacklist");
        }
        for (String string : clientBlacklist) {
            if (string != null) continue;
            throw new NullPointerException("clientBlacklist: null item");
        }
        this.clientBlacklist = new ArrayList<String>(clientBlacklist);
        return this;
    }

    public StyxConfigBuilder clientBlacklist(Iterable<? extends String> clientBlacklist) {
        if (clientBlacklist == null) {
            throw new NullPointerException("clientBlacklist");
        }
        if (clientBlacklist instanceof Collection) {
            return this.clientBlacklist((Collection)clientBlacklist);
        }
        return this.clientBlacklist(clientBlacklist.iterator());
    }

    public StyxConfigBuilder clientBlacklist(Iterator<? extends String> clientBlacklist) {
        if (clientBlacklist == null) {
            throw new NullPointerException("clientBlacklist");
        }
        this.clientBlacklist = new ArrayList<String>();
        while (clientBlacklist.hasNext()) {
            String item = clientBlacklist.next();
            if (item == null) {
                throw new NullPointerException("clientBlacklist: null item");
            }
            this.clientBlacklist.add(item);
        }
        return this;
    }

    @SafeVarargs
    public final StyxConfigBuilder clientBlacklist(String ... clientBlacklist) {
        if (clientBlacklist == null) {
            throw new NullPointerException("clientBlacklist");
        }
        return this.clientBlacklist(Arrays.asList(clientBlacklist));
    }

    public StyxConfig build() {
        List _clientBlacklist = this.clientBlacklist != null ? Collections.unmodifiableList(new ArrayList<String>(this.clientBlacklist)) : Collections.emptyList();
        return new Value(this.globalDockerRunnerId, this.globalEnabled, this.debugEnabled, this.executionGatingEnabled, this.globalConcurrency, this.submissionRateLimit, _clientBlacklist);
    }

    public static StyxConfigBuilder from(StyxConfig v) {
        return new StyxConfigBuilder(v);
    }

    public static StyxConfigBuilder from(StyxConfigBuilder v) {
        return new StyxConfigBuilder(v);
    }

    private static final class Value
    implements StyxConfig {
        private final String globalDockerRunnerId;
        private final boolean globalEnabled;
        private final boolean debugEnabled;
        private final boolean executionGatingEnabled;
        private final Optional<Long> globalConcurrency;
        private final Optional<Double> submissionRateLimit;
        private final List<String> clientBlacklist;

        private Value(@AutoMatter.Field(value="globalDockerRunnerId") String globalDockerRunnerId, @AutoMatter.Field(value="globalEnabled") boolean globalEnabled, @AutoMatter.Field(value="debugEnabled") boolean debugEnabled, @AutoMatter.Field(value="executionGatingEnabled") boolean executionGatingEnabled, @AutoMatter.Field(value="globalConcurrency") Optional<Long> globalConcurrency, @AutoMatter.Field(value="submissionRateLimit") Optional<Double> submissionRateLimit, @AutoMatter.Field(value="clientBlacklist") List<String> clientBlacklist) {
            if (globalDockerRunnerId == null) {
                throw new NullPointerException("globalDockerRunnerId");
            }
            if (globalConcurrency == null) {
                throw new NullPointerException("globalConcurrency");
            }
            if (submissionRateLimit == null) {
                throw new NullPointerException("submissionRateLimit");
            }
            this.globalDockerRunnerId = globalDockerRunnerId;
            this.globalEnabled = globalEnabled;
            this.debugEnabled = debugEnabled;
            this.executionGatingEnabled = executionGatingEnabled;
            this.globalConcurrency = globalConcurrency;
            this.submissionRateLimit = submissionRateLimit;
            this.clientBlacklist = clientBlacklist != null ? clientBlacklist : Collections.emptyList();
        }

        @Override
        @AutoMatter.Field
        public String globalDockerRunnerId() {
            return this.globalDockerRunnerId;
        }

        @Override
        @AutoMatter.Field
        public boolean globalEnabled() {
            return this.globalEnabled;
        }

        @Override
        @AutoMatter.Field
        public boolean debugEnabled() {
            return this.debugEnabled;
        }

        @Override
        @AutoMatter.Field
        public boolean executionGatingEnabled() {
            return this.executionGatingEnabled;
        }

        @Override
        @AutoMatter.Field
        public Optional<Long> globalConcurrency() {
            return this.globalConcurrency;
        }

        @Override
        @AutoMatter.Field
        public Optional<Double> submissionRateLimit() {
            return this.submissionRateLimit;
        }

        @Override
        @AutoMatter.Field
        public List<String> clientBlacklist() {
            return this.clientBlacklist;
        }

        public StyxConfigBuilder builder() {
            return new StyxConfigBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StyxConfig)) {
                return false;
            }
            StyxConfig that = (StyxConfig)o;
            if (this.globalDockerRunnerId != null ? !this.globalDockerRunnerId.equals(that.globalDockerRunnerId()) : that.globalDockerRunnerId() != null) {
                return false;
            }
            if (this.globalEnabled != that.globalEnabled()) {
                return false;
            }
            if (this.debugEnabled != that.debugEnabled()) {
                return false;
            }
            if (this.executionGatingEnabled != that.executionGatingEnabled()) {
                return false;
            }
            if (this.globalConcurrency != null ? !this.globalConcurrency.equals(that.globalConcurrency()) : that.globalConcurrency() != null) {
                return false;
            }
            if (this.submissionRateLimit != null ? !this.submissionRateLimit.equals(that.submissionRateLimit()) : that.submissionRateLimit() != null) {
                return false;
            }
            return !(this.clientBlacklist != null ? !this.clientBlacklist.equals(that.clientBlacklist()) : that.clientBlacklist() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.globalDockerRunnerId != null ? this.globalDockerRunnerId.hashCode() : 0);
            result = 31 * result + (this.globalEnabled ? 1231 : 1237);
            result = 31 * result + (this.debugEnabled ? 1231 : 1237);
            result = 31 * result + (this.executionGatingEnabled ? 1231 : 1237);
            result = 31 * result + (this.globalConcurrency != null ? this.globalConcurrency.hashCode() : 0);
            result = 31 * result + (this.submissionRateLimit != null ? this.submissionRateLimit.hashCode() : 0);
            result = 31 * result + (this.clientBlacklist != null ? this.clientBlacklist.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "StyxConfig{globalDockerRunnerId=" + this.globalDockerRunnerId + ", globalEnabled=" + this.globalEnabled + ", debugEnabled=" + this.debugEnabled + ", executionGatingEnabled=" + this.executionGatingEnabled + ", globalConcurrency=" + this.globalConcurrency + ", submissionRateLimit=" + this.submissionRateLimit + ", clientBlacklist=" + this.clientBlacklist + '}';
        }
    }
}

