/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.model;

import com.spotify.styx.model.TriggerParameters;
import com.spotify.styx.model.TriggerRequest;
import com.spotify.styx.model.WorkflowId;
import io.norberg.automatter.AutoMatter;
import java.util.Optional;

public final class TriggerRequestBuilder {
    private WorkflowId workflowId;
    private String parameter;
    private Optional<TriggerParameters> triggerParameters;

    public TriggerRequestBuilder() {
        this.triggerParameters = Optional.empty();
    }

    private TriggerRequestBuilder(TriggerRequest v) {
        this.workflowId = v.workflowId();
        this.parameter = v.parameter();
        this.triggerParameters = v.triggerParameters();
    }

    private TriggerRequestBuilder(TriggerRequestBuilder v) {
        this.workflowId = v.workflowId;
        this.parameter = v.parameter;
        this.triggerParameters = v.triggerParameters;
    }

    public WorkflowId workflowId() {
        return this.workflowId;
    }

    public TriggerRequestBuilder workflowId(WorkflowId workflowId) {
        if (workflowId == null) {
            throw new NullPointerException("workflowId");
        }
        this.workflowId = workflowId;
        return this;
    }

    public String parameter() {
        return this.parameter;
    }

    public TriggerRequestBuilder parameter(String parameter) {
        if (parameter == null) {
            throw new NullPointerException("parameter");
        }
        this.parameter = parameter;
        return this;
    }

    public Optional<TriggerParameters> triggerParameters() {
        return this.triggerParameters;
    }

    public TriggerRequestBuilder triggerParameters(TriggerParameters triggerParameters) {
        return this.triggerParameters(Optional.ofNullable(triggerParameters));
    }

    public TriggerRequestBuilder triggerParameters(Optional<? extends TriggerParameters> triggerParameters) {
        if (triggerParameters == null) {
            throw new NullPointerException("triggerParameters");
        }
        this.triggerParameters = triggerParameters;
        return this;
    }

    public TriggerRequest build() {
        return new Value(this.workflowId, this.parameter, this.triggerParameters);
    }

    public static TriggerRequestBuilder from(TriggerRequest v) {
        return new TriggerRequestBuilder(v);
    }

    public static TriggerRequestBuilder from(TriggerRequestBuilder v) {
        return new TriggerRequestBuilder(v);
    }

    private static final class Value
    implements TriggerRequest {
        private final WorkflowId workflowId;
        private final String parameter;
        private final Optional<TriggerParameters> triggerParameters;

        private Value(@AutoMatter.Field(value="workflowId") WorkflowId workflowId, @AutoMatter.Field(value="parameter") String parameter, @AutoMatter.Field(value="triggerParameters") Optional<TriggerParameters> triggerParameters) {
            if (workflowId == null) {
                throw new NullPointerException("workflowId");
            }
            if (parameter == null) {
                throw new NullPointerException("parameter");
            }
            if (triggerParameters == null) {
                throw new NullPointerException("triggerParameters");
            }
            this.workflowId = workflowId;
            this.parameter = parameter;
            this.triggerParameters = triggerParameters;
        }

        @Override
        @AutoMatter.Field
        public WorkflowId workflowId() {
            return this.workflowId;
        }

        @Override
        @AutoMatter.Field
        public String parameter() {
            return this.parameter;
        }

        @Override
        @AutoMatter.Field
        public Optional<TriggerParameters> triggerParameters() {
            return this.triggerParameters;
        }

        @Override
        public TriggerRequestBuilder builder() {
            return new TriggerRequestBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TriggerRequest)) {
                return false;
            }
            TriggerRequest that = (TriggerRequest)o;
            if (this.workflowId != null ? !this.workflowId.equals(that.workflowId()) : that.workflowId() != null) {
                return false;
            }
            if (this.parameter != null ? !this.parameter.equals(that.parameter()) : that.parameter() != null) {
                return false;
            }
            return !(this.triggerParameters != null ? !this.triggerParameters.equals(that.triggerParameters()) : that.triggerParameters() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.workflowId != null ? this.workflowId.hashCode() : 0);
            result = 31 * result + (this.parameter != null ? this.parameter.hashCode() : 0);
            result = 31 * result + (this.triggerParameters != null ? this.triggerParameters.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "TriggerRequest{workflowId=" + this.workflowId + ", parameter=" + this.parameter + ", triggerParameters=" + this.triggerParameters + '}';
        }
    }
}

