/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.model.data;

import com.spotify.styx.model.EventVisitor;
import com.spotify.styx.model.ExecutionDescription;
import com.spotify.styx.model.SequenceEvent;
import com.spotify.styx.model.TriggerParameters;
import com.spotify.styx.model.WorkflowInstance;
import com.spotify.styx.model.data.ExecStatus;
import com.spotify.styx.model.data.Execution;
import com.spotify.styx.model.data.Trigger;
import com.spotify.styx.model.data.WorkflowInstanceExecutionData;
import com.spotify.styx.state.Message;
import com.spotify.styx.util.TriggerUtil;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

class WFIExecutionBuilder {
    private List<Trigger> triggerList = new ArrayList<Trigger>();
    private List<Execution> executionList = new ArrayList<Execution>();
    private List<ExecStatus> executionStatusList = new ArrayList<ExecStatus>();
    @Nullable
    private WorkflowInstance currWorkflowInstance;
    @Nullable
    private String currExecutionId;
    @Nullable
    private String currTriggerId = "UNKNOWN";
    private TriggerParameters currTriggerParameters = TriggerParameters.zero();
    @Nullable
    private String currDockerImg;
    @Nullable
    private String currCommitSha;
    private boolean completed;
    @Nullable
    private Instant triggerTs;
    @Nullable
    private Instant eventTs;
    private final EventVisitor visitor = new Reducer();

    WFIExecutionBuilder() {
    }

    private void closeExecution() {
        Execution execution = Execution.create(Optional.ofNullable(this.currExecutionId), Optional.ofNullable(this.currDockerImg), Optional.ofNullable(this.currCommitSha), this.executionStatusList);
        this.executionList.add(execution);
        this.executionStatusList = new ArrayList<ExecStatus>();
        this.currExecutionId = null;
        this.currDockerImg = null;
        this.currCommitSha = null;
    }

    private void closeTrigger() {
        if (!this.executionStatusList.isEmpty()) {
            this.closeExecution();
        }
        Trigger trigger = Trigger.create(this.currTriggerId, this.triggerTs, this.currTriggerParameters, this.completed, this.executionList);
        this.currTriggerId = "UNKNOWN";
        this.currTriggerParameters = TriggerParameters.zero();
        this.triggerList.add(trigger);
        this.executionList = new ArrayList<Execution>();
    }

    WorkflowInstanceExecutionData executionInfo(Iterable<SequenceEvent> events) {
        for (SequenceEvent sequenceEvent : events) {
            this.eventTs = Instant.ofEpochMilli(sequenceEvent.timestamp());
            sequenceEvent.event().accept(this.visitor);
        }
        if (!this.completed) {
            this.closeTrigger();
        }
        return WorkflowInstanceExecutionData.create(this.currWorkflowInstance, this.triggerList);
    }

    private class Reducer
    implements EventVisitor<Void> {
        private Reducer() {
        }

        @Override
        public Void timeTrigger(WorkflowInstance workflowInstance) {
            WFIExecutionBuilder.this.currWorkflowInstance = workflowInstance;
            WFIExecutionBuilder.this.completed = false;
            WFIExecutionBuilder.this.triggerTs = WFIExecutionBuilder.this.eventTs;
            return null;
        }

        @Override
        public Void triggerExecution(WorkflowInstance workflowInstance, com.spotify.styx.state.Trigger trigger, TriggerParameters parameters) {
            WFIExecutionBuilder.this.currWorkflowInstance = workflowInstance;
            WFIExecutionBuilder.this.completed = false;
            WFIExecutionBuilder.this.currTriggerId = TriggerUtil.triggerId(trigger);
            WFIExecutionBuilder.this.currTriggerParameters = parameters;
            WFIExecutionBuilder.this.triggerTs = WFIExecutionBuilder.this.eventTs;
            return null;
        }

        @Override
        public Void info(WorkflowInstance workflowInstance, Message message) {
            WFIExecutionBuilder.this.currWorkflowInstance = workflowInstance;
            return null;
        }

        @Override
        public Void dequeue(WorkflowInstance workflowInstance, Set<String> resourceIds) {
            WFIExecutionBuilder.this.currWorkflowInstance = workflowInstance;
            return null;
        }

        @Override
        public Void created(WorkflowInstance workflowInstance, String executionId, String dockerImage) {
            WFIExecutionBuilder.this.currWorkflowInstance = workflowInstance;
            WFIExecutionBuilder.this.currExecutionId = executionId;
            WFIExecutionBuilder.this.currDockerImg = dockerImage;
            WFIExecutionBuilder.this.executionStatusList.add(ExecStatus.create(WFIExecutionBuilder.this.eventTs, Status.SUBMITTED.toString(), Optional.empty()));
            return null;
        }

        @Override
        public Void submit(WorkflowInstance workflowInstance, ExecutionDescription executionDescription, String executionId) {
            WFIExecutionBuilder.this.currWorkflowInstance = workflowInstance;
            WFIExecutionBuilder.this.currDockerImg = executionDescription.dockerImage();
            if (executionDescription.commitSha().isPresent()) {
                WFIExecutionBuilder.this.currCommitSha = executionDescription.commitSha().get();
            }
            WFIExecutionBuilder.this.currExecutionId = executionId;
            return null;
        }

        @Override
        public Void submitted(WorkflowInstance workflowInstance, String executionId) {
            WFIExecutionBuilder.this.currWorkflowInstance = workflowInstance;
            WFIExecutionBuilder.this.currExecutionId = executionId;
            WFIExecutionBuilder.this.executionStatusList.add(ExecStatus.create(WFIExecutionBuilder.this.eventTs, Status.SUBMITTED.toString(), Optional.empty()));
            return null;
        }

        @Override
        public Void started(WorkflowInstance workflowInstance) {
            WFIExecutionBuilder.this.currWorkflowInstance = workflowInstance;
            WFIExecutionBuilder.this.executionStatusList.add(ExecStatus.create(WFIExecutionBuilder.this.eventTs, Status.STARTED.toString(), Optional.empty()));
            return null;
        }

        @Override
        public Void terminate(WorkflowInstance workflowInstance, Optional<Integer> exitCode) {
            WFIExecutionBuilder.this.currWorkflowInstance = workflowInstance;
            Status status = exitCode.map(c -> {
                if (c == 0) {
                    return Status.SUCCESS;
                }
                if (c == 20) {
                    return Status.MISSING_DEPS;
                }
                return Status.FAILED;
            }).orElse(Status.FAILED);
            Optional<String> message = Status.FAILED == status ? exitCode.map(c -> Optional.of("Exit code: " + c)).orElse(Optional.of("Exit code unknown")) : Optional.empty();
            WFIExecutionBuilder.this.executionStatusList.add(ExecStatus.create(WFIExecutionBuilder.this.eventTs, status.toString(), message));
            WFIExecutionBuilder.this.closeExecution();
            return null;
        }

        @Override
        public Void runError(WorkflowInstance workflowInstance, String message) {
            WFIExecutionBuilder.this.currWorkflowInstance = workflowInstance;
            WFIExecutionBuilder.this.executionStatusList.add(ExecStatus.create(WFIExecutionBuilder.this.eventTs, Status.FAILED.toString(), Optional.ofNullable(message)));
            WFIExecutionBuilder.this.closeExecution();
            return null;
        }

        @Override
        public Void success(WorkflowInstance workflowInstance) {
            WFIExecutionBuilder.this.currWorkflowInstance = workflowInstance;
            WFIExecutionBuilder.this.completed = true;
            WFIExecutionBuilder.this.closeTrigger();
            return null;
        }

        @Override
        public Void retryAfter(WorkflowInstance workflowInstance, long delayMillis) {
            WFIExecutionBuilder.this.currWorkflowInstance = workflowInstance;
            return null;
        }

        @Override
        public Void retry(WorkflowInstance workflowInstance) {
            WFIExecutionBuilder.this.currWorkflowInstance = workflowInstance;
            return null;
        }

        @Override
        public Void stop(WorkflowInstance workflowInstance) {
            WFIExecutionBuilder.this.currWorkflowInstance = workflowInstance;
            WFIExecutionBuilder.this.completed = true;
            WFIExecutionBuilder.this.closeTrigger();
            return null;
        }

        @Override
        public Void timeout(WorkflowInstance workflowInstance) {
            WFIExecutionBuilder.this.currWorkflowInstance = workflowInstance;
            if (WFIExecutionBuilder.this.triggerTs == null) {
                WFIExecutionBuilder.this.triggerTs = WFIExecutionBuilder.this.eventTs;
                return null;
            }
            WFIExecutionBuilder.this.executionStatusList.add(ExecStatus.create(WFIExecutionBuilder.this.eventTs, Status.TIMEOUT.toString(), Optional.empty()));
            WFIExecutionBuilder.this.closeExecution();
            return null;
        }

        @Override
        public Void halt(WorkflowInstance workflowInstance) {
            WFIExecutionBuilder.this.currWorkflowInstance = workflowInstance;
            WFIExecutionBuilder.this.completed = true;
            WFIExecutionBuilder.this.executionStatusList.add(ExecStatus.create(WFIExecutionBuilder.this.eventTs, Status.HALTED.toString(), Optional.empty()));
            WFIExecutionBuilder.this.closeTrigger();
            return null;
        }
    }

    private static enum Status {
        FAILED,
        HALTED,
        MISSING_DEPS,
        STARTED,
        SUBMITTED,
        SUCCESS,
        TIMEOUT;

    }
}

