/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.model.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.spotify.styx.model.SequenceEvent;
import com.spotify.styx.model.WorkflowInstance;
import com.spotify.styx.model.data.AutoValue_WorkflowInstanceExecutionData;
import com.spotify.styx.model.data.Trigger;
import com.spotify.styx.model.data.WFIExecutionBuilder;
import java.util.Comparator;
import java.util.List;

@AutoValue
public abstract class WorkflowInstanceExecutionData {
    public static final Comparator<WorkflowInstanceExecutionData> COMPARATOR = (a, b) -> WorkflowInstance.KEY_COMPARATOR.compare(a.workflowInstance(), b.workflowInstance());

    @JsonProperty
    public abstract WorkflowInstance workflowInstance();

    @JsonProperty
    public abstract List<Trigger> triggers();

    @JsonCreator
    public static WorkflowInstanceExecutionData create(@JsonProperty(value="workflow_instance") WorkflowInstance workflowInstance, @JsonProperty(value="triggers") List<Trigger> triggers) {
        return new AutoValue_WorkflowInstanceExecutionData(workflowInstance, triggers);
    }

    public static WorkflowInstanceExecutionData fromEvents(Iterable<SequenceEvent> events) {
        return new WFIExecutionBuilder().executionInfo(events);
    }
}

