/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.monitoring;

import com.spotify.styx.monitoring.Stats;
import com.spotify.styx.util.Time;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.Objects;
import javaslang.control.Try;

public abstract class MeteredProxy<T>
implements InvocationHandler {
    private final T delegate;
    private final Stats stats;
    private final Time time;

    MeteredProxy(T delegate, Stats stats, Time time) {
        this.delegate = Objects.requireNonNull(delegate);
        this.stats = Objects.requireNonNull(stats);
        this.time = Objects.requireNonNull(time);
    }

    protected static <T> T instrument(Class<? extends T> clazz, MeteredProxy<T> meteredProxy) {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, meteredProxy);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String operation = method.getName();
        Instant t0 = (Instant)this.time.get();
        Try result = Try.of(() -> {
            try {
                return method.invoke(this.delegate, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        });
        long durationMillis = t0.until((Temporal)this.time.get(), ChronoUnit.MILLIS);
        this.checkResult(operation, durationMillis, result, this.stats);
        if (result.isFailure()) {
            throw result.getCause();
        }
        return result.get();
    }

    protected abstract void checkResult(String var1, long var2, Try<?> var4, Stats var5);
}

