/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.monitoring;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.SlidingTimeWindowArrayReservoir;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.spotify.metrics.core.MetricId;
import com.spotify.metrics.core.SemanticMetricBuilder;
import com.spotify.metrics.core.SemanticMetricRegistry;
import com.spotify.styx.model.SequenceEvent;
import com.spotify.styx.model.WorkflowId;
import com.spotify.styx.monitoring.Stats;
import com.spotify.styx.state.RunState;
import com.spotify.styx.util.EventUtil;
import com.spotify.styx.util.Time;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javaslang.Tuple;
import javaslang.Tuple2;
import javaslang.Tuple3;

public final class MetricsStats
implements Stats {
    static final SemanticMetricBuilder<Histogram> HISTOGRAM = new SemanticMetricBuilder<Histogram>(){

        public Histogram newMetric() {
            return new Histogram((Reservoir)new SlidingTimeWindowArrayReservoir(30L, TimeUnit.SECONDS));
        }

        public boolean isInstance(Metric metric) {
            return metric instanceof Histogram;
        }
    };
    private static final String UNIT_SECOND = "s";
    private static final String UNIT_MILLISECOND = "ms";
    private static final MetricId BASE = MetricId.build((String[])new String[]{"styx"});
    static final MetricId QUEUED_EVENTS = BASE.tagged(new String[]{"what", "queued-events-count"}).tagged(new String[]{"unit", "events"});
    static final MetricId ACTIVE_STATES_PER_RUNSTATE_PER_TRIGGER = BASE.tagged(new String[]{"what", "active-states-per-runstate-per-trigger-count"}).tagged(new String[]{"unit", "state"});
    static final MetricId WORKFLOW_COUNT = BASE.tagged(new String[]{"what", "workflow-count"}).tagged(new String[]{"unit", "workflow"});
    static final MetricId RESOURCE_CONFIGURED = BASE.tagged(new String[]{"what", "resource-configured"});
    static final MetricId RESOURCE_USED = BASE.tagged(new String[]{"what", "resource-used"});
    static final MetricId EXIT_CODE_RATE = BASE.tagged(new String[]{"what", "exit-code-rate"});
    static final MetricId STORAGE_DURATION = BASE.tagged(new String[]{"what", "storage-operation-duration"}).tagged(new String[]{"unit", "ms"});
    static final String OPERATION = "operation";
    static final MetricId STORAGE_RATE = BASE.tagged(new String[]{"what", "storage-operation-rate"}).tagged(new String[]{"unit", "operation"});
    static final MetricId DOCKER_DURATION = BASE.tagged(new String[]{"what", "docker-operation-duration"}).tagged(new String[]{"unit", "ms"});
    static final MetricId DOCKER_RATE = BASE.tagged(new String[]{"what", "docker-operation-rate"}).tagged(new String[]{"unit", "operation"});
    static final MetricId DOCKER_ERROR_RATE = BASE.tagged(new String[]{"what", "docker-operation-error-rate"}).tagged(new String[]{"unit", "operation"});
    static final MetricId TRANSITIONING_DURATION = BASE.tagged(new String[]{"what", "time-transitioning-between-submitted-running"}).tagged(new String[]{"unit", "s"});
    static final MetricId PULL_IMAGE_ERROR_RATE = BASE.tagged(new String[]{"what", "pull-image-error-rate"}).tagged(new String[]{"unit", "error"});
    static final MetricId NATURAL_TRIGGER_RATE = BASE.tagged(new String[]{"what", "natural-trigger-rate"}).tagged(new String[]{"unit", "trigger"});
    static final MetricId TERMINATION_LOG_MISSING = BASE.tagged(new String[]{"what", "termination-log-missing"});
    static final MetricId TERMINATION_LOG_INVALID = BASE.tagged(new String[]{"what", "termination-log-invalid"});
    static final MetricId EXIT_CODE_MISMATCH = BASE.tagged(new String[]{"what", "exit-code-mismatch"});
    static final MetricId SUBMISSION_RATE_LIMIT = BASE.tagged(new String[]{"what", "submission-rate-limit"}).tagged(new String[]{"unit", "submission/s"});
    static final MetricId EVENT_CONSUMER_RATE = BASE.tagged(new String[]{"what", "event-consumer-rate"});
    static final MetricId EVENT_CONSUMER_ERROR_RATE = BASE.tagged(new String[]{"what", "event-consumer-error-rate"}).tagged(new String[]{"unit", "error"});
    static final MetricId WORKFLOW_CONSUMER_RATE = BASE.tagged(new String[]{"what", "workflow-consumer-rate"});
    static final MetricId WORKFLOW_CONSUMER_ERROR_RATE = BASE.tagged(new String[]{"what", "workflow-consumer-error-rate"}).tagged(new String[]{"unit", "error"});
    static final MetricId PUBLISHING_RATE = BASE.tagged(new String[]{"what", "publishing-rate"});
    static final MetricId PUBLISHING_ERROR_RATE = BASE.tagged(new String[]{"what", "publishing-error-rate"}).tagged(new String[]{"unit", "error"});
    static final MetricId TICK_DURATION = BASE.tagged(new String[]{"what", "tick-duration"}).tagged(new String[]{"unit", "ms"});
    static final MetricId DATASTORE_OPERATION_RATE = BASE.tagged(new String[]{"what", "datastore-operation-rate"});
    static final MetricId COUNTER_CACHE_RATE = BASE.tagged(new String[]{"what", "counter-cache-rate"});
    private static final String STATUS = "status";
    private static final String COUNTER_CACHE_RESULT = "result";
    private static final String COUNTER_CACHE_HIT = "hit";
    private static final String COUNTER_CACHE_MISS = "miss";
    private final SemanticMetricRegistry registry;
    private final Time time;
    private final Histogram submitToRunning;
    private final Meter pullImageErrorMeter;
    private final Meter naturalTrigger;
    private final Meter terminationLogMissing;
    private final Meter terminationLogInvalid;
    private final Meter exitCodeMismatch;
    private final Meter workflowConsumerErrorMeter;
    private final Meter counterCacheHitMeter;
    private final Meter counterCacheMissMeter;
    private final ConcurrentMap<String, Histogram> storageOperationHistograms;
    private final ConcurrentMap<String, Meter> storageOperationMeters;
    private final ConcurrentMap<String, Histogram> dockerOperationHistograms;
    private final ConcurrentMap<String, Meter> dockerOperationMeters;
    private final ConcurrentMap<Tuple2<WorkflowId, Integer>, Meter> exitCodePerWorkflowMeters;
    private final ConcurrentMap<Tuple3<String, String, Integer>, Meter> dockerOperationErrorMeters;
    private final ConcurrentMap<String, Histogram> resourceConfiguredHistograms;
    private final ConcurrentMap<String, Histogram> resourceUsedHistograms;
    private final ConcurrentMap<String, Meter> eventConsumerErrorMeters;
    private final ConcurrentMap<String, Meter> eventConsumerMeters;
    private final ConcurrentMap<String, Meter> publishingMeters;
    private final ConcurrentMap<String, Meter> publishingErrorMeters;
    private final ConcurrentMap<String, Meter> workflowConsumerMeters;
    private final ConcurrentMap<String, Histogram> tickHistograms;
    private final ConcurrentMap<Tuple2<String, String>, Meter> datastoreOperationMeters;
    private final Cache<String, Long> submissionTimestamps = CacheBuilder.newBuilder().maximumSize(100000L).build();

    public MetricsStats(SemanticMetricRegistry registry, Time time) {
        this.registry = Objects.requireNonNull(registry);
        this.time = Objects.requireNonNull(time, "time");
        this.submitToRunning = (Histogram)registry.getOrAdd(TRANSITIONING_DURATION, HISTOGRAM);
        this.pullImageErrorMeter = registry.meter(PULL_IMAGE_ERROR_RATE);
        this.naturalTrigger = registry.meter(NATURAL_TRIGGER_RATE);
        this.terminationLogMissing = registry.meter(TERMINATION_LOG_MISSING);
        this.terminationLogInvalid = registry.meter(TERMINATION_LOG_INVALID);
        this.exitCodeMismatch = registry.meter(EXIT_CODE_MISMATCH);
        this.workflowConsumerErrorMeter = registry.meter(WORKFLOW_CONSUMER_ERROR_RATE);
        this.counterCacheHitMeter = registry.meter(COUNTER_CACHE_RATE.tagged(new String[]{COUNTER_CACHE_RESULT, COUNTER_CACHE_HIT}));
        this.counterCacheMissMeter = registry.meter(COUNTER_CACHE_RATE.tagged(new String[]{COUNTER_CACHE_RESULT, COUNTER_CACHE_MISS}));
        this.storageOperationHistograms = new ConcurrentHashMap<String, Histogram>();
        this.storageOperationMeters = new ConcurrentHashMap<String, Meter>();
        this.dockerOperationHistograms = new ConcurrentHashMap<String, Histogram>();
        this.dockerOperationMeters = new ConcurrentHashMap<String, Meter>();
        this.exitCodePerWorkflowMeters = new ConcurrentHashMap<Tuple2<WorkflowId, Integer>, Meter>();
        this.dockerOperationErrorMeters = new ConcurrentHashMap<Tuple3<String, String, Integer>, Meter>();
        this.resourceConfiguredHistograms = new ConcurrentHashMap<String, Histogram>();
        this.resourceUsedHistograms = new ConcurrentHashMap<String, Histogram>();
        this.eventConsumerErrorMeters = new ConcurrentHashMap<String, Meter>();
        this.eventConsumerMeters = new ConcurrentHashMap<String, Meter>();
        this.publishingMeters = new ConcurrentHashMap<String, Meter>();
        this.publishingErrorMeters = new ConcurrentHashMap<String, Meter>();
        this.workflowConsumerMeters = new ConcurrentHashMap<String, Meter>();
        this.tickHistograms = new ConcurrentHashMap<String, Histogram>();
        this.datastoreOperationMeters = new ConcurrentHashMap<Tuple2<String, String>, Meter>();
    }

    @Override
    public void registerQueuedEventsMetric(Gauge<Long> queuedEventsCount) {
        this.registry.register(QUEUED_EVENTS, queuedEventsCount);
    }

    @Override
    public void registerActiveStatesMetric(RunState.State state, String triggerName, Gauge<Long> activeStatesCount) {
        this.registry.register(ACTIVE_STATES_PER_RUNSTATE_PER_TRIGGER.tagged(new String[]{"state", state.name(), "trigger", triggerName}), activeStatesCount);
    }

    @Override
    public void registerWorkflowCountMetric(String status, Gauge<Long> workflowCount) {
        this.registry.register(WORKFLOW_COUNT.tagged(new String[]{STATUS, status}), workflowCount);
    }

    @Override
    public void registerSubmissionRateLimitMetric(Gauge<Double> submissionRateLimit) {
        this.registry.register(SUBMISSION_RATE_LIMIT, submissionRateLimit);
    }

    @Override
    public void recordStorageOperation(String operation, long durationMillis, String status) {
        this.storageOpHistogram(operation, status).update(durationMillis);
        this.storageOpMeter(operation, status).mark();
    }

    @Override
    public void recordDockerOperation(String operation, long durationMillis, String status) {
        this.dockerOpHistogram(operation, status).update(durationMillis);
        this.dockerOpMeter(operation, status).mark();
    }

    @Override
    public void recordDockerOperationError(String operation, String type, int code, long durationMillis) {
        this.dockerOpErrorMeter(operation, type, code).mark();
    }

    @Override
    public void recordSubmission(String executionId) {
        this.submissionTimestamps.put((Object)executionId, (Object)this.time.nanoTime());
    }

    @Override
    public void recordRunning(String executionId) {
        Long submissionNanos = (Long)this.submissionTimestamps.getIfPresent((Object)executionId);
        if (submissionNanos != null) {
            long runningNanos = this.time.nanoTime();
            this.submissionTimestamps.invalidate((Object)executionId);
            this.submitToRunning.update(TimeUnit.NANOSECONDS.toSeconds(runningNanos - submissionNanos));
        }
    }

    @Override
    public void recordExitCode(WorkflowId workflowId, int exitCode) {
        this.exitCodeMeter(workflowId, exitCode).mark();
    }

    @Override
    public void recordPullImageError() {
        this.pullImageErrorMeter.mark();
    }

    @Override
    public void recordNaturalTrigger() {
        this.naturalTrigger.mark();
    }

    @Override
    public void recordTerminationLogMissing() {
        this.terminationLogMissing.mark();
    }

    @Override
    public void recordTerminationLogInvalid() {
        this.terminationLogInvalid.mark();
    }

    @Override
    public void recordExitCodeMismatch() {
        this.exitCodeMismatch.mark();
    }

    @Override
    public void recordResourceConfigured(String resource, long configured) {
        this.resourceConfiguredHistogram(resource).update(configured);
    }

    @Override
    public void recordResourceUsed(String resource, long used) {
        this.resourceUsedHistogram(resource).update(used);
    }

    @Override
    public void recordEventConsumer(SequenceEvent event) {
        this.eventConsumerMeter(event).mark();
    }

    @Override
    public void recordEventConsumerError(SequenceEvent event) {
        this.eventConsumerErrorMeter(event).mark();
    }

    @Override
    public void recordWorkflowConsumer(String action) {
        this.workflowConsumerMeter(action).mark();
    }

    @Override
    public void recordWorkflowConsumerError() {
        this.workflowConsumerErrorMeter.mark();
    }

    @Override
    public void recordPublishing(String type, String state) {
        this.publishingMeter(type, state).mark();
    }

    @Override
    public void recordPublishingError(String type, String state) {
        this.publishingErrorMeter(type, state).mark();
    }

    @Override
    public void recordTickDuration(String type, long duration) {
        this.tickHistogram(type).update(duration);
    }

    @Override
    public void recordDatastoreEntityReads(String kind, int n) {
        this.recordDatastoreOperations("read", kind, n);
    }

    @Override
    public void recordDatastoreEntityWrites(String kind, int n) {
        this.recordDatastoreOperations("write", kind, n);
    }

    @Override
    public void recordDatastoreEntityDeletes(String kind, int n) {
        this.recordDatastoreOperations("delete", kind, n);
    }

    @Override
    public void recordDatastoreQueries(String kind, int n) {
        this.recordDatastoreOperations("query", kind, n);
    }

    @Override
    public void recordCounterCacheHit() {
        this.counterCacheHitMeter.mark();
    }

    @Override
    public void recordCounterCacheMiss() {
        this.counterCacheMissMeter.mark();
    }

    private void recordDatastoreOperations(String operation, String kind, int n) {
        this.datastoreOperationMeter(operation, kind).mark((long)n);
    }

    private Meter exitCodeMeter(WorkflowId workflowId, int exitCode) {
        return this.exitCodePerWorkflowMeters.computeIfAbsent((Tuple2<WorkflowId, Integer>)Tuple.of((Object)workflowId, (Object)exitCode), tuple -> this.registry.meter(EXIT_CODE_RATE.tagged(new String[]{"component-id", ((WorkflowId)tuple._1).componentId(), "workflow-id", ((WorkflowId)tuple._1).id(), "exit-code", String.valueOf(tuple._2)})));
    }

    private Meter dockerOpErrorMeter(String operation, String type, int code) {
        return this.dockerOperationErrorMeters.computeIfAbsent((Tuple3<String, String, Integer>)Tuple.of((Object)operation, (Object)type, (Object)code), tuple -> this.registry.meter(DOCKER_ERROR_RATE.tagged(new String[]{OPERATION, (String)tuple._1, "type", (String)tuple._2, "code", String.valueOf(tuple._3)})));
    }

    private Histogram storageOpHistogram(String operation, String status) {
        return this.storageOperationHistograms.computeIfAbsent(operation, op -> (Histogram)this.registry.getOrAdd(STORAGE_DURATION.tagged(new String[]{OPERATION, op, STATUS, status}), HISTOGRAM));
    }

    private Meter storageOpMeter(String operation, String status) {
        return this.storageOperationMeters.computeIfAbsent(operation, op -> this.registry.meter(STORAGE_RATE.tagged(new String[]{OPERATION, op, STATUS, status})));
    }

    private Histogram dockerOpHistogram(String operation, String status) {
        return this.dockerOperationHistograms.computeIfAbsent(operation, op -> (Histogram)this.registry.getOrAdd(DOCKER_DURATION.tagged(new String[]{OPERATION, op, STATUS, status}), HISTOGRAM));
    }

    private Meter dockerOpMeter(String operation, String status) {
        return this.dockerOperationMeters.computeIfAbsent(operation, op -> this.registry.meter(DOCKER_RATE.tagged(new String[]{OPERATION, op, STATUS, status})));
    }

    private Histogram resourceConfiguredHistogram(String resource) {
        return this.resourceConfiguredHistograms.computeIfAbsent(resource, op -> (Histogram)this.registry.getOrAdd(RESOURCE_CONFIGURED.tagged(new String[]{"resource", resource}), HISTOGRAM));
    }

    private Histogram resourceUsedHistogram(String resource) {
        return this.resourceUsedHistograms.computeIfAbsent(resource, op -> (Histogram)this.registry.getOrAdd(RESOURCE_USED.tagged(new String[]{"resource", resource}), HISTOGRAM));
    }

    private Meter eventConsumerMeter(SequenceEvent sequenceEvent) {
        String eventType = EventUtil.name(sequenceEvent.event());
        return this.eventConsumerMeters.computeIfAbsent(eventType, op -> this.registry.meter(EVENT_CONSUMER_RATE.tagged(new String[]{"event-type", eventType})));
    }

    private Meter eventConsumerErrorMeter(SequenceEvent sequenceEvent) {
        String eventType = EventUtil.name(sequenceEvent.event());
        return this.eventConsumerErrorMeters.computeIfAbsent(eventType, op -> this.registry.meter(EVENT_CONSUMER_ERROR_RATE.tagged(new String[]{"event-type", eventType})));
    }

    private Meter workflowConsumerMeter(String action) {
        return this.workflowConsumerMeters.computeIfAbsent(action, op -> this.registry.meter(WORKFLOW_CONSUMER_RATE.tagged(new String[]{"action", action})));
    }

    private Meter publishingMeter(String type, String state) {
        return this.publishingMeters.computeIfAbsent(type, op -> this.registry.meter(PUBLISHING_RATE.tagged(new String[]{"type", type, "state", state})));
    }

    private Meter publishingErrorMeter(String type, String state) {
        return this.publishingErrorMeters.computeIfAbsent(type, op -> this.registry.meter(PUBLISHING_ERROR_RATE.tagged(new String[]{"type", type, "state", state})));
    }

    private Histogram tickHistogram(String type) {
        return this.tickHistograms.computeIfAbsent(type, op -> (Histogram)this.registry.getOrAdd(TICK_DURATION.tagged(new String[]{"type", type}), HISTOGRAM));
    }

    private Meter datastoreOperationMeter(String operation, String kind) {
        return this.datastoreOperationMeters.computeIfAbsent((Tuple2<String, String>)Tuple.of((Object)operation, (Object)kind), t -> this.registry.meter(DATASTORE_OPERATION_RATE.tagged(new String[]{OPERATION, operation, "kind", kind})));
    }
}

