/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.monitoring;

import io.opencensus.common.Scope;
import io.opencensus.trace.SpanBuilder;
import io.opencensus.trace.Status;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Objects;

public class TracingProxy
implements InvocationHandler {
    private final Object delegate;
    private final String delegateName;
    private final Tracer tracer;

    private TracingProxy(Object delegate, Tracer tracer) {
        this.delegate = Objects.requireNonNull(delegate);
        this.delegateName = delegate.getClass().getSimpleName();
        this.tracer = tracer;
    }

    public static <T> T instrument(Class<T> iface, T delegate) {
        return TracingProxy.instrument(iface, delegate, Tracing.getTracer());
    }

    public static <T> T instrument(Class<T> iface, T delegate, Tracer tracer) {
        return (T)Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface}, (InvocationHandler)new TracingProxy(delegate, tracer));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String operation = method.getName();
        SpanBuilder spanBuilder = this.tracer.spanBuilder(this.delegateName + "." + operation);
        Throwable throwable = null;
        try (Scope ss = spanBuilder.startScopedSpan();){
            Object object = method.invoke(this.delegate, args);
            return object;
        }
        catch (InvocationTargetException e) {
            try {
                this.tracer.getCurrentSpan().addAnnotation("Exception thrown");
                this.tracer.getCurrentSpan().setStatus(Status.UNKNOWN);
                throw e.getTargetException();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

