/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.serialization;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.collect.ImmutableSet;
import com.spotify.styx.model.Event;
import com.spotify.styx.model.EventVisitor;
import com.spotify.styx.model.ExecutionDescription;
import com.spotify.styx.model.TriggerParameters;
import com.spotify.styx.model.WorkflowInstance;
import com.spotify.styx.state.Message;
import com.spotify.styx.state.Trigger;
import java.util.Optional;
import java.util.Set;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=PersistentEvent.class, name="timeTrigger"), @JsonSubTypes.Type(value=TriggerExecution.class, name="triggerExecution"), @JsonSubTypes.Type(value=Info.class, name="info"), @JsonSubTypes.Type(value=Created.class, name="created"), @JsonSubTypes.Type(value=Dequeue.class, name="dequeue"), @JsonSubTypes.Type(value=Started.class, name="started"), @JsonSubTypes.Type(value=Terminate.class, name="terminate"), @JsonSubTypes.Type(value=RunError.class, name="runError"), @JsonSubTypes.Type(value=RetryAfter.class, name="retryAfter"), @JsonSubTypes.Type(value=PersistentEvent.class, name="success"), @JsonSubTypes.Type(value=PersistentEvent.class, name="retry"), @JsonSubTypes.Type(value=PersistentEvent.class, name="stop"), @JsonSubTypes.Type(value=PersistentEvent.class, name="timeout"), @JsonSubTypes.Type(value=PersistentEvent.class, name="halt"), @JsonSubTypes.Type(value=Submit.class, name="submit"), @JsonSubTypes.Type(value=Submitted.class, name="submitted")})
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
class PersistentEvent {
    private static final SerializerVisitor SERIALIZER_VISITOR = new SerializerVisitor();
    @JsonTypeId
    @JsonProperty(value="@type")
    public final String type;
    public final String workflowInstance;

    @JsonCreator
    PersistentEvent(@JsonProperty(value="@type") String type, @JsonProperty(value="workflow_instance") String workflowInstance) {
        this.type = type;
        this.workflowInstance = workflowInstance;
    }

    public static PersistentEvent wrap(Event event) {
        return event.accept(SERIALIZER_VISITOR);
    }

    public Event toEvent() {
        WorkflowInstance workflowInstance = WorkflowInstance.parseKey(this.workflowInstance);
        switch (this.type) {
            case "timeTrigger": {
                return Event.timeTrigger(workflowInstance);
            }
            case "success": {
                return Event.success(workflowInstance);
            }
            case "retry": {
                return Event.retry(workflowInstance);
            }
            case "stop": {
                return Event.stop(workflowInstance);
            }
            case "timeout": {
                return Event.timeout(workflowInstance);
            }
            case "halt": {
                return Event.halt(workflowInstance);
            }
        }
        throw new IllegalStateException("Event type " + this.type + " not covered by base PersistentEvent class");
    }

    public static class Submit
    extends PersistentEvent {
        public final ExecutionDescription executionDescription;
        public final String executionId;

        @JsonCreator
        public Submit(@JsonProperty(value="workflow_instance") String workflowInstance, @JsonProperty(value="execution_description") ExecutionDescription executionDescription, @JsonProperty(value="execution_id") String executionId) {
            super("submit", workflowInstance);
            this.executionDescription = executionDescription;
            this.executionId = executionId;
        }

        @Override
        public Event toEvent() {
            return Event.submit(WorkflowInstance.parseKey(this.workflowInstance), this.executionDescription, this.executionId);
        }
    }

    public static class RetryAfter
    extends PersistentEvent {
        public final long delayMillis;

        @JsonCreator
        public RetryAfter(@JsonProperty(value="workflow_instance") String workflowInstance, @JsonProperty(value="delay_millis") long delayMillis) {
            super("retryAfter", workflowInstance);
            this.delayMillis = delayMillis;
        }

        @Override
        public Event toEvent() {
            return Event.retryAfter(WorkflowInstance.parseKey(this.workflowInstance), this.delayMillis);
        }
    }

    public static class Dequeue
    extends PersistentEvent {
        public final Set<String> resourceIds;

        @JsonCreator
        public Dequeue(@JsonProperty(value="workflow_instance") String workflowInstance, @JsonProperty(value="resource_ids") Optional<Set<String>> resourceIds) {
            super("dequeue", workflowInstance);
            this.resourceIds = resourceIds.orElse((Set<String>)ImmutableSet.of());
        }

        @Override
        public Event toEvent() {
            return Event.dequeue(WorkflowInstance.parseKey(this.workflowInstance), this.resourceIds);
        }
    }

    public static class RunError
    extends PersistentEvent {
        public final String message;

        @JsonCreator
        public RunError(@JsonProperty(value="workflow_instance") String workflowInstance, @JsonProperty(value="message") String message) {
            super("runError", workflowInstance);
            this.message = message;
        }

        @Override
        public Event toEvent() {
            return Event.runError(WorkflowInstance.parseKey(this.workflowInstance), this.message);
        }
    }

    public static class Terminate
    extends PersistentEvent {
        public final Optional<Integer> exitCode;

        @JsonCreator
        public Terminate(@JsonProperty(value="workflow_instance") String workflowInstance, @JsonProperty(value="exit_code") Optional<Integer> exitCode) {
            super("terminate", workflowInstance);
            this.exitCode = exitCode;
        }

        @Override
        public Event toEvent() {
            return Event.terminate(WorkflowInstance.parseKey(this.workflowInstance), this.exitCode);
        }
    }

    public static class Started
    extends PersistentEvent {
        public final Optional<String> podName = Optional.empty();

        @JsonCreator
        public Started(@JsonProperty(value="workflow_instance") String workflowInstance) {
            super("started", workflowInstance);
        }

        @Override
        public Event toEvent() {
            return Event.started(WorkflowInstance.parseKey(this.workflowInstance));
        }
    }

    public static class Submitted
    extends PersistentEvent {
        public final String executionId;

        @JsonCreator
        public Submitted(@JsonProperty(value="workflow_instance") String workflowInstance, @JsonProperty(value="execution_id") String executionId) {
            super("submitted", workflowInstance);
            this.executionId = executionId;
        }

        @Override
        public Event toEvent() {
            return Event.submitted(WorkflowInstance.parseKey(this.workflowInstance), this.executionId);
        }
    }

    public static class Created
    extends PersistentEvent {
        public final String executionId;
        public final String dockerImage;

        @JsonCreator
        public Created(@JsonProperty(value="workflow_instance") String workflowInstance, @JsonProperty(value="execution_id") String executionId, @JsonProperty(value="docker_image") Optional<String> dockerImage) {
            super("created", workflowInstance);
            this.executionId = executionId;
            this.dockerImage = dockerImage.orElse("UNKNOWN");
        }

        @Override
        public Event toEvent() {
            return Event.created(WorkflowInstance.parseKey(this.workflowInstance), this.executionId, this.dockerImage);
        }
    }

    public static class Info
    extends PersistentEvent {
        public final Message message;

        @JsonCreator
        public Info(@JsonProperty(value="workflow_instance") String workflowInstance, @JsonProperty(value="message") Message message) {
            super("info", workflowInstance);
            this.message = message;
        }

        @Override
        public Event toEvent() {
            return Event.info(WorkflowInstance.parseKey(this.workflowInstance), this.message);
        }
    }

    public static class TriggerExecution
    extends PersistentEvent {
        public final Optional<String> triggerId = Optional.empty();
        public final Optional<Trigger> trigger;
        public final Optional<TriggerParameters> parameters;

        @JsonCreator
        public TriggerExecution(@JsonProperty(value="workflow_instance") String workflowInstance, @JsonProperty(value="trigger") Optional<Trigger> trigger, @JsonProperty(value="parameters") Optional<TriggerParameters> parameters) {
            super("triggerExecution", workflowInstance);
            this.trigger = trigger;
            this.parameters = parameters;
        }

        @Override
        public Event toEvent() {
            return Event.triggerExecution(WorkflowInstance.parseKey(this.workflowInstance), this.trigger(), this.parameters.orElse(TriggerParameters.zero()));
        }

        private Trigger trigger() {
            if (this.trigger.isPresent()) {
                return this.trigger.get();
            }
            if (this.triggerId.isPresent()) {
                return Trigger.unknown(this.triggerId.get());
            }
            return Trigger.unknown("UNKNOWN");
        }
    }

    public static class SerializerVisitor
    implements EventVisitor<PersistentEvent> {
        @Override
        public PersistentEvent timeTrigger(WorkflowInstance workflowInstance) {
            return new PersistentEvent("timeTrigger", workflowInstance.toKey());
        }

        @Override
        public PersistentEvent triggerExecution(WorkflowInstance workflowInstance, Trigger trigger, TriggerParameters parameters) {
            return new TriggerExecution(workflowInstance.toKey(), Optional.of(trigger), Optional.of(parameters));
        }

        @Override
        public PersistentEvent info(WorkflowInstance workflowInstance, Message message) {
            return new Info(workflowInstance.toKey(), message);
        }

        @Override
        public PersistentEvent created(WorkflowInstance workflowInstance, String executionId, String dockerImage) {
            return new Created(workflowInstance.toKey(), executionId, Optional.of(dockerImage));
        }

        @Override
        public PersistentEvent dequeue(WorkflowInstance workflowInstance, Set<String> resourceIds) {
            return new Dequeue(workflowInstance.toKey(), Optional.of(resourceIds));
        }

        @Override
        public PersistentEvent submit(WorkflowInstance workflowInstance, ExecutionDescription executionDescription, String executionId) {
            return new Submit(workflowInstance.toKey(), executionDescription, executionId);
        }

        @Override
        public PersistentEvent submitted(WorkflowInstance workflowInstance, String executionId) {
            return new Submitted(workflowInstance.toKey(), executionId);
        }

        @Override
        public PersistentEvent started(WorkflowInstance workflowInstance) {
            return new Started(workflowInstance.toKey());
        }

        @Override
        public PersistentEvent terminate(WorkflowInstance workflowInstance, Optional<Integer> exitCode) {
            return new Terminate(workflowInstance.toKey(), exitCode);
        }

        @Override
        public PersistentEvent runError(WorkflowInstance workflowInstance, String message) {
            return new RunError(workflowInstance.toKey(), message);
        }

        @Override
        public PersistentEvent success(WorkflowInstance workflowInstance) {
            return new PersistentEvent("success", workflowInstance.toKey());
        }

        @Override
        public PersistentEvent retryAfter(WorkflowInstance workflowInstance, long delayMillis) {
            return new RetryAfter(workflowInstance.toKey(), delayMillis);
        }

        @Override
        public PersistentEvent retry(WorkflowInstance workflowInstance) {
            return new PersistentEvent("retry", workflowInstance.toKey());
        }

        @Override
        public PersistentEvent stop(WorkflowInstance workflowInstance) {
            return new PersistentEvent("stop", workflowInstance.toKey());
        }

        @Override
        public PersistentEvent timeout(WorkflowInstance workflowInstance) {
            return new PersistentEvent("timeout", workflowInstance.toKey());
        }

        @Override
        public PersistentEvent halt(WorkflowInstance workflowInstance) {
            return new PersistentEvent("halt", workflowInstance.toKey());
        }
    }
}

