/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.state;

import com.google.auto.value.AutoValue;
import com.spotify.styx.model.Event;
import com.spotify.styx.model.EventVisitor;
import com.spotify.styx.model.ExecutionDescription;
import com.spotify.styx.model.TriggerParameters;
import com.spotify.styx.model.WorkflowInstance;
import com.spotify.styx.state.AutoValue_RunState;
import com.spotify.styx.state.Message;
import com.spotify.styx.state.StateData;
import com.spotify.styx.state.Trigger;
import com.spotify.styx.util.Time;
import com.spotify.styx.util.TriggerUtil;
import java.time.Instant;
import java.util.Optional;
import java.util.Set;

@AutoValue
public abstract class RunState {
    private static final int SUCCESS_EXIT_CODE = 0;
    public static final int MISSING_DEPS_EXIT_CODE = 20;
    private static final double FAILURE_COST = 1.0;
    private static final double MISSING_DEPS_COST = 0.1;
    private static final long NO_EVENTS_PROCESSED = -1L;
    private final EventVisitor<RunState> visitor = new TransitionVisitor();

    public abstract WorkflowInstance workflowInstance();

    public abstract State state();

    public abstract long timestamp();

    public abstract StateData data();

    public abstract long counter();

    public static RunState fresh(WorkflowInstance workflowInstance, Time time) {
        return RunState.create(workflowInstance, State.NEW, (Instant)time.get());
    }

    public static RunState fresh(WorkflowInstance workflowInstance) {
        return RunState.fresh(workflowInstance, Instant::now);
    }

    public RunState transition(Event event, Time time) {
        return event.accept(this.visitor).transitionUpdates((Instant)time.get());
    }

    private RunState state(State state, StateData newStateData) {
        return new AutoValue_RunState(this.workflowInstance(), state, this.timestamp(), newStateData, this.counter());
    }

    private RunState state(State state) {
        return new AutoValue_RunState(this.workflowInstance(), state, this.timestamp(), this.data(), this.counter());
    }

    private RunState transitionUpdates(Instant instant) {
        return new AutoValue_RunState(this.workflowInstance(), this.state(), instant.toEpochMilli(), this.data(), this.counter() + 1L);
    }

    private IllegalStateException illegalTransition(String event) {
        return new IllegalStateException(this.workflowInstance() + " received " + event + " while in " + (Object)((Object)this.state()));
    }

    public static RunState create(WorkflowInstance workflowInstance, State state) {
        return RunState.create(workflowInstance, state, StateData.zero());
    }

    public static RunState create(WorkflowInstance workflowInstance, State state, Instant timestamp) {
        return RunState.create(workflowInstance, state, StateData.zero(), timestamp);
    }

    public static RunState create(WorkflowInstance workflowInstance, State state, Instant timestamp, long counter) {
        return RunState.create(workflowInstance, state, StateData.zero(), timestamp, counter);
    }

    public static RunState create(WorkflowInstance workflowInstance, State state, StateData stateData) {
        return new AutoValue_RunState(workflowInstance, state, System.currentTimeMillis(), stateData, -1L);
    }

    public static RunState create(WorkflowInstance workflowInstance, State state, StateData stateData, Instant timestamp) {
        return new AutoValue_RunState(workflowInstance, state, timestamp.toEpochMilli(), stateData, -1L);
    }

    public static RunState create(WorkflowInstance workflowInstance, State state, StateData stateData, Instant timestamp, long counter) {
        return new AutoValue_RunState(workflowInstance, state, timestamp.toEpochMilli(), stateData, counter);
    }

    private class TransitionVisitor
    implements EventVisitor<RunState> {
        private TransitionVisitor() {
        }

        @Override
        @Deprecated
        public RunState timeTrigger(WorkflowInstance workflowInstance) {
            switch (RunState.this.state()) {
                case NEW: {
                    return RunState.this.state(State.SUBMITTED, RunState.this.data().builder().trigger(Trigger.unknown("UNKNOWN")).triggerId("UNKNOWN").build());
                }
            }
            throw RunState.this.illegalTransition("timeTrigger");
        }

        @Override
        public RunState triggerExecution(WorkflowInstance workflowInstance, Trigger trigger, TriggerParameters parameters) {
            switch (RunState.this.state()) {
                case NEW: {
                    return RunState.this.state(State.QUEUED, RunState.this.data().builder().trigger(trigger).triggerId(TriggerUtil.triggerId(trigger)).triggerParameters(parameters).build());
                }
            }
            throw RunState.this.illegalTransition("triggerExecution");
        }

        @Override
        @Deprecated
        public RunState created(WorkflowInstance workflowInstance, String executionId, String dockerImage) {
            switch (RunState.this.state()) {
                case PREPARE: 
                case QUEUED: {
                    return RunState.this.state(State.SUBMITTED, RunState.this.data().builder().executionId(executionId).executionDescription(ExecutionDescription.forImage(dockerImage)).tries(RunState.this.data().tries() + 1).build());
                }
            }
            throw RunState.this.illegalTransition("created");
        }

        @Override
        public RunState info(WorkflowInstance workflowInstance, Message message) {
            switch (RunState.this.state()) {
                case QUEUED: {
                    return RunState.this.state(State.QUEUED, RunState.this.data().builder().messages(message).build());
                }
            }
            throw RunState.this.illegalTransition("info");
        }

        @Override
        public RunState dequeue(WorkflowInstance workflowInstance, Set<String> resourceIds) {
            switch (RunState.this.state()) {
                case QUEUED: {
                    return RunState.this.state(State.PREPARE, RunState.this.data().builder().retryDelayMillis(Optional.empty()).resourceIds(resourceIds).build());
                }
            }
            throw RunState.this.illegalTransition("dequeue");
        }

        @Override
        public RunState submit(WorkflowInstance workflowInstance, ExecutionDescription executionDescription, String executionId) {
            switch (RunState.this.state()) {
                case PREPARE: 
                case QUEUED: {
                    return RunState.this.state(State.SUBMITTING, RunState.this.data().builder().executionDescription(executionDescription).executionId(executionId).build());
                }
            }
            throw RunState.this.illegalTransition("submit");
        }

        @Override
        public RunState submitted(WorkflowInstance workflowInstance, String executionId) {
            switch (RunState.this.state()) {
                case SUBMITTING: {
                    return RunState.this.state(State.SUBMITTED, RunState.this.data().builder().tries(RunState.this.data().tries() + 1).executionId(RunState.this.data().executionId().orElse(executionId)).build());
                }
            }
            throw RunState.this.illegalTransition("submitted");
        }

        @Override
        public RunState started(WorkflowInstance workflowInstance) {
            switch (RunState.this.state()) {
                case PREPARE: 
                case SUBMITTED: {
                    return RunState.this.state(State.RUNNING);
                }
            }
            throw RunState.this.illegalTransition("started");
        }

        @Override
        public RunState terminate(WorkflowInstance workflowInstance, Optional<Integer> exitCode) {
            switch (RunState.this.state()) {
                case RUNNING: {
                    double cost = this.exitCost(exitCode);
                    int consecutiveFailures = this.consecutiveFailures(RunState.this.data(), exitCode);
                    Message.MessageLevel level = this.messageLevel(exitCode);
                    StateData newStateData = RunState.this.data().builder().retryCost(RunState.this.data().retryCost() + cost).lastExit(exitCode).consecutiveFailures(consecutiveFailures).messages(Message.create(level, "Exit code: " + exitCode.map(String::valueOf).orElse("-"))).build();
                    return RunState.this.state(State.TERMINATED, newStateData);
                }
            }
            throw RunState.this.illegalTransition("terminate");
        }

        double exitCost(Optional<Integer> exitCode) {
            return exitCode.map(c -> {
                switch (c) {
                    case 0: {
                        return 0.0;
                    }
                    case 20: {
                        return 0.1;
                    }
                }
                return 1.0;
            }).orElse(1.0);
        }

        int consecutiveFailures(StateData data, Optional<Integer> exitCode) {
            return exitCode.map(c -> {
                switch (c) {
                    case 0: 
                    case 20: {
                        return 0;
                    }
                }
                return data.consecutiveFailures() + 1;
            }).orElse(data.consecutiveFailures() + 1);
        }

        Message.MessageLevel messageLevel(Optional<Integer> exitCode) {
            return exitCode.map(c -> {
                switch (c) {
                    case 0: {
                        return Message.MessageLevel.INFO;
                    }
                    case 20: {
                        return Message.MessageLevel.WARNING;
                    }
                }
                return Message.MessageLevel.ERROR;
            }).orElse(Message.MessageLevel.ERROR);
        }

        @Override
        public RunState runError(WorkflowInstance workflowInstance, String message) {
            switch (RunState.this.state()) {
                case PREPARE: 
                case QUEUED: 
                case SUBMITTING: 
                case SUBMITTED: 
                case RUNNING: {
                    StateData newStateData = RunState.this.data().builder().retryCost(RunState.this.data().retryCost() + 1.0).lastExit(Optional.empty()).consecutiveFailures(RunState.this.data().consecutiveFailures() + 1).messages(Message.error(message)).build();
                    return RunState.this.state(State.FAILED, newStateData);
                }
            }
            throw RunState.this.illegalTransition("runError");
        }

        @Override
        public RunState success(WorkflowInstance workflowInstance) {
            switch (RunState.this.state()) {
                case TERMINATED: {
                    return RunState.this.state(State.DONE);
                }
            }
            throw RunState.this.illegalTransition("success");
        }

        @Override
        public RunState retryAfter(WorkflowInstance workflowInstance, long delayMillis) {
            switch (RunState.this.state()) {
                case QUEUED: 
                case TERMINATED: 
                case FAILED: {
                    return RunState.this.state(State.QUEUED, RunState.this.data().builder().retryDelayMillis(delayMillis).executionId(Optional.empty()).executionDescription(Optional.empty()).resourceIds(Optional.empty()).build());
                }
            }
            throw RunState.this.illegalTransition("retryAfter");
        }

        @Override
        @Deprecated
        public RunState retry(WorkflowInstance workflowInstance) {
            switch (RunState.this.state()) {
                case QUEUED: 
                case TERMINATED: 
                case FAILED: {
                    return RunState.this.state(State.PREPARE);
                }
            }
            throw RunState.this.illegalTransition("retry");
        }

        @Override
        public RunState stop(WorkflowInstance workflowInstance) {
            switch (RunState.this.state()) {
                case TERMINATED: 
                case FAILED: {
                    return RunState.this.state(State.ERROR);
                }
            }
            throw RunState.this.illegalTransition("stop");
        }

        @Override
        public RunState timeout(WorkflowInstance workflowInstance) {
            return RunState.this.state(State.FAILED);
        }

        @Override
        public RunState halt(WorkflowInstance workflowInstance) {
            return RunState.this.state(State.ERROR);
        }
    }

    public static enum State {
        NEW(false),
        QUEUED(false),
        PREPARE(false),
        SUBMITTING(false),
        SUBMITTED(false),
        RUNNING(false),
        TERMINATED(false),
        FAILED(false),
        ERROR(true),
        DONE(true);

        private final boolean terminal;

        private State(boolean terminal) {
            this.terminal = terminal;
        }

        public boolean isTerminal() {
            return this.terminal;
        }
    }
}

