/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.storage;

import com.google.cloud.datastore.Datastore;
import com.spotify.styx.model.Backfill;
import com.spotify.styx.model.Resource;
import com.spotify.styx.model.SequenceEvent;
import com.spotify.styx.model.StyxConfig;
import com.spotify.styx.model.Workflow;
import com.spotify.styx.model.WorkflowId;
import com.spotify.styx.model.WorkflowInstance;
import com.spotify.styx.model.WorkflowState;
import com.spotify.styx.model.data.WorkflowInstanceExecutionData;
import com.spotify.styx.state.RunState;
import com.spotify.styx.storage.BigtableStorage;
import com.spotify.styx.storage.CheckedDatastore;
import com.spotify.styx.storage.DatastoreStorage;
import com.spotify.styx.storage.Storage;
import com.spotify.styx.storage.TransactionFunction;
import com.spotify.styx.util.TriggerInstantSpec;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import org.apache.hadoop.hbase.client.Connection;

public class AggregateStorage
implements Storage {
    private final BigtableStorage bigtableStorage;
    private final DatastoreStorage datastoreStorage;

    public AggregateStorage(Connection connection, Datastore datastore, Duration retryBaseDelay) {
        this(new BigtableStorage(connection, retryBaseDelay), new DatastoreStorage(new CheckedDatastore(datastore), retryBaseDelay));
    }

    AggregateStorage(BigtableStorage bigtableStorage, DatastoreStorage datastoreStorage) {
        this.bigtableStorage = Objects.requireNonNull(bigtableStorage, "bigtableStorage");
        this.datastoreStorage = Objects.requireNonNull(datastoreStorage, "datastoreStorage");
    }

    @Override
    public void close() throws IOException {
        this.datastoreStorage.close();
    }

    @Override
    public SortedSet<SequenceEvent> readEvents(WorkflowInstance workflowInstance) throws IOException {
        return this.bigtableStorage.readEvents(workflowInstance);
    }

    @Override
    public void writeEvent(SequenceEvent sequenceEvent) throws IOException {
        this.bigtableStorage.writeEvent(sequenceEvent);
    }

    @Override
    public Optional<Long> getLatestStoredCounter(WorkflowInstance workflowInstance) throws IOException {
        return this.bigtableStorage.getLatestStoredCounter(workflowInstance);
    }

    @Override
    public StyxConfig config() throws IOException {
        return this.datastoreStorage.config();
    }

    @Override
    public Map<WorkflowInstance, RunState> readActiveStates() throws IOException {
        return this.datastoreStorage.readActiveStates();
    }

    @Override
    public Map<WorkflowInstance, RunState> readActiveStates(String componentId) throws IOException {
        return this.datastoreStorage.readActiveStates(componentId);
    }

    @Override
    public Optional<RunState> readActiveState(WorkflowInstance workflowInstance) throws IOException {
        return this.datastoreStorage.readActiveState(workflowInstance);
    }

    @Override
    public Map<WorkflowInstance, RunState> readActiveStatesByTriggerId(String triggerId) throws IOException {
        return this.datastoreStorage.activeStatesByTriggerId(triggerId);
    }

    @Override
    public void writeActiveState(WorkflowInstance workflowInstance, RunState state) throws IOException {
        this.datastoreStorage.writeActiveState(workflowInstance, state);
    }

    @Override
    public void deleteActiveState(WorkflowInstance workflowInstance) throws IOException {
        this.datastoreStorage.deleteActiveState(workflowInstance);
    }

    @Override
    public boolean enabled(WorkflowId workflowId) throws IOException {
        return this.datastoreStorage.enabled(workflowId);
    }

    @Override
    public Set<WorkflowId> enabled() throws IOException {
        return this.datastoreStorage.enabled();
    }

    @Override
    public WorkflowInstanceExecutionData executionData(WorkflowInstance workflowInstance) throws IOException {
        return this.bigtableStorage.executionData(workflowInstance);
    }

    @Override
    public List<WorkflowInstanceExecutionData> executionData(WorkflowId workflowId, String offset, int limit) throws IOException {
        return this.bigtableStorage.executionData(workflowId, offset, limit);
    }

    @Override
    public List<WorkflowInstanceExecutionData> executionData(WorkflowId workflowId, String start, String stop) throws IOException {
        return this.bigtableStorage.executionData(workflowId, start, stop);
    }

    @Override
    public void storeWorkflow(Workflow workflow) throws IOException {
        this.datastoreStorage.store(workflow);
    }

    @Override
    public Optional<Workflow> workflow(WorkflowId workflowId) throws IOException {
        return this.datastoreStorage.workflow(workflowId);
    }

    @Override
    public List<Workflow> workflows(String componentId) throws IOException {
        return this.datastoreStorage.workflows(componentId);
    }

    @Override
    public void delete(WorkflowId workflowId) throws IOException {
        this.datastoreStorage.delete(workflowId);
    }

    @Override
    public void updateNextNaturalTrigger(WorkflowId workflowId, TriggerInstantSpec triggerSpec) throws IOException {
        this.datastoreStorage.updateNextNaturalTrigger(workflowId, triggerSpec);
    }

    @Override
    public Map<Workflow, TriggerInstantSpec> workflowsWithNextNaturalTrigger() throws IOException {
        return this.datastoreStorage.workflowsWithNextNaturalTrigger();
    }

    @Override
    public Map<WorkflowId, Workflow> workflows() throws IOException {
        return this.datastoreStorage.workflows();
    }

    @Override
    public Map<WorkflowId, Workflow> workflows(Set<WorkflowId> workflowIds) {
        return this.datastoreStorage.workflows(workflowIds);
    }

    @Override
    public void patchState(WorkflowId workflowId, WorkflowState state) throws IOException {
        this.datastoreStorage.patchState(workflowId, state);
    }

    @Override
    public WorkflowState workflowState(WorkflowId workflowId) throws IOException {
        return this.datastoreStorage.workflowState(workflowId);
    }

    @Override
    public Optional<Resource> resource(String id) throws IOException {
        return this.datastoreStorage.getResource(id);
    }

    @Override
    public List<Resource> resources() throws IOException {
        return this.datastoreStorage.getResources();
    }

    @Override
    public void deleteResource(String id) throws IOException {
        this.datastoreStorage.deleteResource(id);
    }

    @Override
    public void storeResource(Resource resource) throws IOException {
        this.datastoreStorage.storeResource(resource);
    }

    @Override
    public void storeBackfill(Backfill backfill) throws IOException {
        this.datastoreStorage.storeBackfill(backfill);
    }

    @Override
    public Map<Integer, Long> shardsForCounter(String counterId) throws IOException {
        return this.datastoreStorage.shardsForCounter(counterId);
    }

    @Override
    public long getLimitForCounter(String counterId) throws IOException {
        return this.datastoreStorage.getLimitForCounter(counterId);
    }

    @Override
    public List<Backfill> backfills(boolean showAll) throws IOException {
        return this.datastoreStorage.getBackfills(showAll);
    }

    @Override
    public List<Backfill> backfillsForComponent(boolean showAll, String component) throws IOException {
        return this.datastoreStorage.getBackfillsForComponent(showAll, component);
    }

    @Override
    public List<Backfill> backfillsForWorkflow(boolean showAll, String workflow) throws IOException {
        return this.datastoreStorage.getBackfillsForWorkflow(showAll, workflow);
    }

    @Override
    public List<Backfill> backfillsForWorkflowId(boolean showAll, WorkflowId workflowId) throws IOException {
        return this.datastoreStorage.getBackfillsForWorkflowId(showAll, workflowId);
    }

    @Override
    public Optional<Backfill> backfill(String id) throws IOException {
        return this.datastoreStorage.getBackfill(id);
    }

    @Override
    public <T, E extends Exception> T runInTransaction(TransactionFunction<T, E> f) throws IOException, E {
        return this.datastoreStorage.runInTransaction(f);
    }
}

