/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.storage;

import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.DatastoreException;
import com.google.cloud.datastore.DatastoreReaderWriter;
import com.google.cloud.datastore.IncompleteKey;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.KeyFactory;
import com.spotify.styx.storage.CheckedDatastoreReaderWriter;
import com.spotify.styx.storage.CheckedDatastoreTransaction;
import com.spotify.styx.storage.DatastoreIOException;
import java.io.IOException;
import java.util.Objects;

class CheckedDatastore
extends CheckedDatastoreReaderWriter {
    private final Datastore datastore;

    CheckedDatastore(Datastore datastore) {
        super((DatastoreReaderWriter)datastore);
        this.datastore = Objects.requireNonNull(datastore);
    }

    KeyFactory newKeyFactory() {
        return this.datastore.newKeyFactory();
    }

    CheckedDatastoreTransaction newTransaction() throws DatastoreIOException {
        try {
            return new CheckedDatastoreTransaction(this, this.datastore.newTransaction());
        }
        catch (DatastoreException e) {
            throw new DatastoreIOException(e);
        }
    }

    Key allocateId(IncompleteKey newKey) throws IOException {
        return CheckedDatastore.call(() -> this.datastore.allocateId(newKey));
    }
}

