/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.storage;

import com.google.cloud.datastore.DatastoreException;
import com.google.cloud.datastore.DatastoreReaderWriter;
import com.google.cloud.datastore.Entity;
import com.google.cloud.datastore.FullEntity;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.Query;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.spotify.styx.storage.DatastoreIOException;
import com.spotify.styx.storage.IOConsumer;
import com.spotify.styx.storage.RuntimeIOException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

class CheckedDatastoreReaderWriter {
    private final DatastoreReaderWriter rw;

    CheckedDatastoreReaderWriter(DatastoreReaderWriter rw) {
        this.rw = Objects.requireNonNull(rw);
    }

    Entity put(FullEntity<?> entity) throws IOException {
        return CheckedDatastoreReaderWriter.call(() -> this.rw.put(entity));
    }

    Entity add(FullEntity<?> entity) throws IOException {
        return CheckedDatastoreReaderWriter.call(() -> this.rw.add(entity));
    }

    void update(Entity ... entites) throws IOException {
        CheckedDatastoreReaderWriter.run(() -> this.rw.update(entites));
    }

    Entity get(Key key) throws IOException {
        return CheckedDatastoreReaderWriter.call(() -> this.rw.get(key));
    }

    List<Entity> get(Iterable<Key> keys) throws IOException {
        return (List)CheckedDatastoreReaderWriter.call(() -> ImmutableList.copyOf((Iterator)this.rw.get((Key[])Iterables.toArray((Iterable)keys, Key.class))));
    }

    void get(Iterable<Key> keys, IOConsumer<Entity> f) throws IOException {
        CheckedDatastoreReaderWriter.run(() -> this.rw.get((Key[])Iterables.toArray((Iterable)keys, Key.class)).forEachRemaining(IOConsumer.unchecked(f)));
    }

    <T> List<T> query(Query<T> query) throws IOException {
        return (List)CheckedDatastoreReaderWriter.call(() -> ImmutableList.copyOf((Iterator)this.rw.run(query)));
    }

    <T> void query(Query<T> query, IOConsumer<T> f) throws IOException {
        CheckedDatastoreReaderWriter.run(() -> this.rw.run(query).forEachRemaining(IOConsumer.unchecked(f)));
    }

    void delete(Key ... keys) throws IOException {
        CheckedDatastoreReaderWriter.run(() -> this.rw.delete(keys));
    }

    static <T> T call(Supplier<T> f) throws IOException {
        try {
            return f.get();
        }
        catch (DatastoreException e) {
            throw new DatastoreIOException(e);
        }
        catch (RuntimeIOException e) {
            throw e.getCause();
        }
    }

    static void run(Runnable f) throws IOException {
        CheckedDatastoreReaderWriter.call(() -> {
            f.run();
            return null;
        });
    }
}

