/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.storage;

import com.google.cloud.datastore.DatastoreException;
import com.google.cloud.datastore.DatastoreReaderWriter;
import com.google.cloud.datastore.Transaction;
import com.spotify.styx.storage.CheckedDatastore;
import com.spotify.styx.storage.CheckedDatastoreReaderWriter;
import com.spotify.styx.storage.DatastoreIOException;
import java.util.Objects;

class CheckedDatastoreTransaction
extends CheckedDatastoreReaderWriter {
    private final CheckedDatastore datastore;
    final Transaction tx;

    CheckedDatastoreTransaction(CheckedDatastore datastore, Transaction tx) {
        super((DatastoreReaderWriter)tx);
        this.datastore = Objects.requireNonNull(datastore);
        this.tx = Objects.requireNonNull(tx);
    }

    Transaction.Response commit() throws DatastoreIOException {
        try {
            return this.tx.commit();
        }
        catch (DatastoreException e) {
            throw new DatastoreIOException(e);
        }
    }

    void rollback() throws DatastoreIOException {
        try {
            this.tx.rollback();
        }
        catch (DatastoreException e) {
            throw new DatastoreIOException(e);
        }
    }

    boolean isActive() {
        return this.tx.isActive();
    }

    CheckedDatastore getDatastore() {
        return this.datastore;
    }
}

