/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.storage;

import com.google.cloud.datastore.Entity;
import com.google.cloud.datastore.FullEntity;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.KeyFactory;
import com.google.cloud.datastore.StringValue;
import com.google.cloud.datastore.Value;
import com.spotify.styx.model.Backfill;
import com.spotify.styx.model.Resource;
import com.spotify.styx.model.Workflow;
import com.spotify.styx.model.WorkflowId;
import com.spotify.styx.model.WorkflowInstance;
import com.spotify.styx.model.WorkflowState;
import com.spotify.styx.serialization.Json;
import com.spotify.styx.state.RunState;
import com.spotify.styx.storage.CheckedDatastore;
import com.spotify.styx.storage.CheckedDatastoreTransaction;
import com.spotify.styx.storage.DatastoreIOException;
import com.spotify.styx.storage.DatastoreStorage;
import com.spotify.styx.storage.StorageTransaction;
import com.spotify.styx.storage.TransactionException;
import com.spotify.styx.util.ResourceNotFoundException;
import com.spotify.styx.util.Shard;
import com.spotify.styx.util.ShardedCounter;
import com.spotify.styx.util.TriggerInstantSpec;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;

public class DatastoreStorageTransaction
implements StorageTransaction {
    private final CheckedDatastoreTransaction tx;

    public DatastoreStorageTransaction(CheckedDatastoreTransaction transaction) {
        this.tx = Objects.requireNonNull(transaction);
    }

    @Override
    public void commit() throws TransactionException {
        try {
            this.tx.commit();
        }
        catch (DatastoreIOException e) {
            throw new TransactionException(e.getCause());
        }
    }

    @Override
    public void rollback() throws TransactionException {
        try {
            this.tx.rollback();
        }
        catch (DatastoreIOException e) {
            throw new TransactionException(e.getCause());
        }
    }

    @Override
    public boolean isActive() {
        return this.tx.isActive();
    }

    @Override
    public void updateCounter(ShardedCounter shardedCounter, String resource, int delta) throws IOException {
        shardedCounter.updateCounter(this, resource, delta);
    }

    @Override
    public Optional<Shard> shard(String counterId, int shardIndex) throws IOException {
        Key shardKey = ((KeyFactory)this.tx.getDatastore().newKeyFactory().setKind("CounterShard")).newKey(counterId + "-" + shardIndex);
        Entity shardEntity = this.tx.get(shardKey);
        if (shardEntity == null) {
            return Optional.empty();
        }
        return Optional.of(Shard.create(counterId, shardIndex, (int)this.tx.get(shardKey).getLong("value")));
    }

    @Override
    public void store(Shard shard) throws IOException {
        this.tx.put((FullEntity<?>)((Entity.Builder)((Entity.Builder)((Entity.Builder)Entity.newBuilder((Key)((KeyFactory)this.tx.getDatastore().newKeyFactory().setKind("CounterShard")).newKey(shard.counterId() + "-" + shard.index())).set("counterId", shard.counterId())).set("index", (long)shard.index())).set("value", (long)shard.value())).build());
    }

    @Override
    public void updateLimitForCounter(String counterId, long limit) throws IOException {
        Key limitKey = ((KeyFactory)this.tx.getDatastore().newKeyFactory().setKind("CounterLimit")).newKey(counterId);
        this.tx.put((FullEntity<?>)((Entity.Builder)Entity.newBuilder((Key)limitKey).set("limit", limit)).build());
    }

    @Override
    public void store(Resource resource) throws IOException {
        this.tx.put((FullEntity<?>)this.resourceToEntity(this.tx.getDatastore(), resource));
    }

    private Entity resourceToEntity(CheckedDatastore datastore, Resource resource) {
        Key key = ((KeyFactory)datastore.newKeyFactory().setKind("CounterLimit")).newKey(resource.id());
        return ((Entity.Builder)Entity.newBuilder((Key)key).set("limit", resource.concurrency())).build();
    }

    @Override
    public WorkflowId store(Workflow workflow) throws IOException {
        Key componentKey = DatastoreStorage.componentKey(this.tx.getDatastore().newKeyFactory(), workflow.componentId());
        if (this.tx.get(componentKey) == null) {
            this.tx.put((FullEntity<?>)Entity.newBuilder((Key)componentKey).build());
        }
        String json = Json.OBJECT_MAPPER.writeValueAsString((Object)workflow);
        Key workflowKey = DatastoreStorage.workflowKey(this.tx.getDatastore().newKeyFactory(), workflow.id());
        Optional<Entity> workflowOpt = DatastoreStorage.getOpt(this.tx, workflowKey);
        Entity workflowEntity = ((Entity.Builder)DatastoreStorage.asBuilderOrNew(workflowOpt, workflowKey).set("json", (Value)((StringValue.Builder)StringValue.newBuilder((String)json).setExcludeFromIndexes(true)).build())).build();
        this.tx.put((FullEntity<?>)workflowEntity);
        return workflow.id();
    }

    @Override
    public WorkflowId storeWorkflowWithNextNaturalTrigger(Workflow workflow, TriggerInstantSpec triggerSpec) throws IOException {
        Key componentKey = DatastoreStorage.componentKey(this.tx.getDatastore().newKeyFactory(), workflow.componentId());
        if (this.tx.get(componentKey) == null) {
            this.tx.put((FullEntity<?>)Entity.newBuilder((Key)componentKey).build());
        }
        String json = Json.OBJECT_MAPPER.writeValueAsString((Object)workflow);
        Key workflowKey = DatastoreStorage.workflowKey(this.tx.getDatastore().newKeyFactory(), workflow.id());
        Optional<Entity> workflowOpt = DatastoreStorage.getOpt(this.tx, workflowKey);
        Entity.Builder entity = (Entity.Builder)((Entity.Builder)((Entity.Builder)DatastoreStorage.asBuilderOrNew(workflowOpt, workflowKey).set("json", (Value)((StringValue.Builder)StringValue.newBuilder((String)json).setExcludeFromIndexes(true)).build())).set("nextNaturalTrigger", DatastoreStorage.instantToTimestamp(triggerSpec.instant()))).set("nextNaturalOffsetTrigger", DatastoreStorage.instantToTimestamp(triggerSpec.offsetInstant()));
        this.tx.put((FullEntity<?>)entity.build());
        return workflow.id();
    }

    @Override
    public Optional<Workflow> workflow(WorkflowId workflowId) throws IOException {
        Optional<Entity> entityOptional = DatastoreStorage.getOpt(this.tx, DatastoreStorage.workflowKey(this.tx.getDatastore().newKeyFactory(), workflowId));
        if (entityOptional.isPresent()) {
            return Optional.of(DatastoreStorage.parseWorkflowJson(entityOptional.get(), workflowId));
        }
        return Optional.empty();
    }

    @Override
    public WorkflowId updateNextNaturalTrigger(WorkflowId workflowId, TriggerInstantSpec triggerSpec) throws IOException {
        Key workflowKey = DatastoreStorage.workflowKey(this.tx.getDatastore().newKeyFactory(), workflowId);
        Optional<Entity> workflowOpt = DatastoreStorage.getOpt(this.tx, workflowKey);
        if (!workflowOpt.isPresent()) {
            throw new ResourceNotFoundException(String.format("%s:%s doesn't exist.", workflowId.componentId(), workflowId.id()));
        }
        Entity.Builder builder = (Entity.Builder)((Entity.Builder)Entity.newBuilder((Entity)workflowOpt.get()).set("nextNaturalTrigger", DatastoreStorage.instantToTimestamp(triggerSpec.instant()))).set("nextNaturalOffsetTrigger", DatastoreStorage.instantToTimestamp(triggerSpec.offsetInstant()));
        this.tx.put((FullEntity<?>)builder.build());
        return workflowId;
    }

    @Override
    public WorkflowId patchState(WorkflowId workflowId, WorkflowState state) throws IOException {
        Key workflowKey = DatastoreStorage.workflowKey(this.tx.getDatastore().newKeyFactory(), workflowId);
        Optional<Entity> workflowOpt = DatastoreStorage.getOpt(this.tx, workflowKey);
        if (!workflowOpt.isPresent()) {
            throw new ResourceNotFoundException(String.format("%s:%s doesn't exist.", workflowId.componentId(), workflowId.id()));
        }
        Entity.Builder builder = Entity.newBuilder((Entity)workflowOpt.get());
        state.enabled().ifPresent(x -> {
            Entity.Builder cfr_ignored_0 = (Entity.Builder)builder.set("enabled", x.booleanValue());
        });
        state.nextNaturalTrigger().ifPresent(x -> {
            Entity.Builder cfr_ignored_0 = (Entity.Builder)builder.set("nextNaturalTrigger", DatastoreStorage.instantToTimestamp(x));
        });
        state.nextNaturalOffsetTrigger().ifPresent(x -> {
            Entity.Builder cfr_ignored_0 = (Entity.Builder)builder.set("nextNaturalOffsetTrigger", DatastoreStorage.instantToTimestamp(x));
        });
        this.tx.put((FullEntity<?>)builder.build());
        return workflowId;
    }

    @Override
    public Optional<RunState> readActiveState(WorkflowInstance instance) throws IOException {
        Entity entity = this.tx.get(DatastoreStorage.activeWorkflowInstanceKey(this.tx.getDatastore().newKeyFactory(), instance));
        if (entity == null) {
            return Optional.empty();
        }
        return Optional.of(DatastoreStorage.entityToRunState(entity, instance));
    }

    @Override
    public WorkflowInstance writeActiveState(WorkflowInstance instance, RunState state) throws IOException {
        Key indexEntryKey = DatastoreStorage.activeWorkflowInstanceIndexShardEntryKey(this.tx.getDatastore().newKeyFactory(), instance);
        Entity indexEntry = Entity.newBuilder((Key)indexEntryKey).build();
        this.tx.add((FullEntity<?>)indexEntry);
        this.tx.add((FullEntity<?>)DatastoreStorage.runStateToEntity(this.tx.getDatastore().newKeyFactory(), instance, state));
        return instance;
    }

    @Override
    public WorkflowInstance updateActiveState(WorkflowInstance instance, RunState state) throws IOException {
        this.tx.update(DatastoreStorage.runStateToEntity(this.tx.getDatastore().newKeyFactory(), instance, state));
        return instance;
    }

    @Override
    public WorkflowInstance deleteActiveState(WorkflowInstance instance) throws IOException {
        this.tx.delete(DatastoreStorage.activeWorkflowInstanceIndexShardEntryKey(this.tx.getDatastore().newKeyFactory(), instance));
        this.tx.delete(DatastoreStorage.activeWorkflowInstanceKey(this.tx.getDatastore().newKeyFactory(), instance));
        return instance;
    }

    @Override
    public Backfill store(Backfill backfill) throws IOException {
        Key key = DatastoreStorage.backfillKey(this.tx.getDatastore().newKeyFactory(), backfill.id());
        Entity.Builder builder = (Entity.Builder)((Entity.Builder)((Entity.Builder)((Entity.Builder)((Entity.Builder)((Entity.Builder)((Entity.Builder)((Entity.Builder)((Entity.Builder)((Entity.Builder)Entity.newBuilder((Key)key).set("concurrency", (long)backfill.concurrency())).set("start", DatastoreStorage.instantToTimestamp(backfill.start()))).set("end", DatastoreStorage.instantToTimestamp(backfill.end()))).set("component", backfill.workflowId().componentId())).set("workflow", backfill.workflowId().id())).set("schedule", backfill.schedule().toString())).set("nextTrigger", DatastoreStorage.instantToTimestamp(backfill.nextTrigger()))).set("allTriggered", backfill.allTriggered())).set("halted", backfill.halted())).set("reverse", backfill.reverse());
        backfill.description().ifPresent(x -> {
            Entity.Builder cfr_ignored_0 = (Entity.Builder)builder.set("description", (Value)((StringValue.Builder)StringValue.newBuilder((String)x).setExcludeFromIndexes(true)).build());
        });
        if (backfill.triggerParameters().isPresent()) {
            String json = Json.OBJECT_MAPPER.writeValueAsString((Object)backfill.triggerParameters().get());
            builder.set("triggerParameters", (Value)((StringValue.Builder)StringValue.newBuilder((String)json).setExcludeFromIndexes(true)).build());
        }
        this.tx.put((FullEntity<?>)builder.build());
        return backfill;
    }

    @Override
    public Optional<Backfill> backfill(String id) throws IOException {
        Key key = DatastoreStorage.backfillKey(this.tx.getDatastore().newKeyFactory(), id);
        Entity entity = this.tx.get(key);
        if (entity == null) {
            return Optional.empty();
        }
        return Optional.of(DatastoreStorage.entityToBackfill(entity));
    }
}

