/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.storage;

import com.google.cloud.datastore.Batch;
import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.DatastoreOptions;
import com.google.cloud.datastore.DatastoreReaderWriter;
import com.google.cloud.datastore.Entity;
import com.google.cloud.datastore.FullEntity;
import com.google.cloud.datastore.IncompleteKey;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.KeyFactory;
import com.google.cloud.datastore.Query;
import com.google.cloud.datastore.QueryResults;
import com.google.cloud.datastore.ReadOption;
import com.google.cloud.datastore.Transaction;
import com.google.datastore.v1.TransactionOptions;
import com.spotify.styx.monitoring.Stats;
import com.spotify.styx.storage.InstrumentedBatch;
import com.spotify.styx.storage.InstrumentedDatastoreReaderWriter;
import com.spotify.styx.storage.InstrumentedQueryResults;
import com.spotify.styx.storage.InstrumentedTransaction;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class InstrumentedDatastore
implements Datastore,
InstrumentedDatastoreReaderWriter {
    private final Stats stats;
    private final Datastore delegate;

    private InstrumentedDatastore(Datastore delegate, Stats stats) {
        this.delegate = delegate;
        this.stats = Objects.requireNonNull(stats, "stats");
    }

    public Transaction newTransaction(TransactionOptions transactionOptions) {
        return InstrumentedTransaction.of(this.stats, this.delegate.newTransaction(transactionOptions));
    }

    public Transaction newTransaction() {
        return InstrumentedTransaction.of(this.stats, this.delegate.newTransaction());
    }

    public <T> T runInTransaction(Datastore.TransactionCallable<T> transactionCallable) {
        return (T)this.delegate.runInTransaction(rw -> transactionCallable.run((DatastoreReaderWriter)InstrumentedDatastoreReaderWriter.of(this.stats, rw)));
    }

    public <T> T runInTransaction(Datastore.TransactionCallable<T> transactionCallable, TransactionOptions transactionOptions) {
        return (T)this.delegate.runInTransaction(rw -> transactionCallable.run((DatastoreReaderWriter)InstrumentedDatastoreReaderWriter.of(this.stats, rw)), transactionOptions);
    }

    public Batch newBatch() {
        return InstrumentedBatch.of(this.stats, this.delegate.newBatch());
    }

    public Entity get(Key key, ReadOption ... readOptions) {
        this.stats.recordDatastoreEntityReads(key.getKind(), 1);
        return this.delegate.get(key, readOptions);
    }

    public Iterator<Entity> get(Iterable<Key> keys, ReadOption ... readOptions) {
        keys.forEach(key -> this.stats.recordDatastoreEntityReads(key.getKind(), 1));
        return this.delegate.get(keys, readOptions);
    }

    public List<Entity> fetch(Iterable<Key> keys, ReadOption ... readOptions) {
        keys.forEach(key -> this.stats.recordDatastoreEntityReads(key.getKind(), 1));
        return this.delegate.fetch(keys, readOptions);
    }

    public <T> QueryResults<T> run(Query<T> query, ReadOption ... readOptions) {
        QueryResults results = this.delegate.run(query, readOptions);
        return InstrumentedQueryResults.of(this.stats, query, results);
    }

    public Key allocateId(IncompleteKey key) {
        return this.delegate.allocateId(key);
    }

    public List<Key> allocateId(IncompleteKey ... keys) {
        return this.delegate.allocateId(keys);
    }

    @Override
    public Entity add(FullEntity<?> entity) {
        return InstrumentedDatastoreReaderWriter.super.add(entity);
    }

    @Override
    public List<Entity> add(FullEntity<?> ... entities) {
        return InstrumentedDatastoreReaderWriter.super.add(entities);
    }

    @Override
    public void update(Entity ... entities) {
        InstrumentedDatastoreReaderWriter.super.update(entities);
    }

    @Override
    public Entity put(FullEntity<?> entity) {
        return InstrumentedDatastoreReaderWriter.super.put(entity);
    }

    @Override
    public List<Entity> put(FullEntity<?> ... entities) {
        return InstrumentedDatastoreReaderWriter.super.put(entities);
    }

    @Override
    public void delete(Key ... keys) {
        InstrumentedDatastoreReaderWriter.super.delete(keys);
    }

    public KeyFactory newKeyFactory() {
        return this.delegate.newKeyFactory();
    }

    public DatastoreOptions getOptions() {
        return (DatastoreOptions)this.delegate.getOptions();
    }

    @Override
    public Stats stats() {
        return this.stats;
    }

    @Override
    public DatastoreReaderWriter readerWriter() {
        return this.delegate;
    }

    public Datastore delegate() {
        return this.delegate;
    }

    public static InstrumentedDatastore of(Datastore delegate, Stats stats) {
        return new InstrumentedDatastore(delegate, stats);
    }
}

