/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.storage;

import com.google.cloud.datastore.Batch;
import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.DatastoreWriter;
import com.google.cloud.datastore.Entity;
import com.google.cloud.datastore.FullEntity;
import com.google.cloud.datastore.Key;
import com.spotify.styx.monitoring.Stats;
import com.spotify.styx.storage.InstrumentedDatastoreWriter;
import java.util.List;
import java.util.Objects;

interface InstrumentedDatastoreBatchWriter
extends Batch,
InstrumentedDatastoreWriter {
    @Override
    public Stats stats();

    public Batch batch();

    default public Batch.Response submit() {
        return this.batch().submit();
    }

    default public Datastore getDatastore() {
        return this.batch().getDatastore();
    }

    default public void addWithDeferredIdAllocation(FullEntity<?> ... entities) {
        for (FullEntity<?> entity : entities) {
            this.stats().recordDatastoreEntityWrites(entity.getKey().getKind(), 1);
        }
        this.batch().addWithDeferredIdAllocation(entities);
    }

    default public void putWithDeferredIdAllocation(FullEntity<?> ... entities) {
        for (FullEntity<?> entity : entities) {
            this.stats().recordDatastoreEntityWrites(entity.getKey().getKind(), 1);
        }
        this.batch().putWithDeferredIdAllocation(entities);
    }

    default public boolean isActive() {
        return this.batch().isActive();
    }

    @Override
    default public Entity add(FullEntity<?> entity) {
        return InstrumentedDatastoreWriter.super.add(entity);
    }

    @Override
    default public List<Entity> add(FullEntity<?> ... entities) {
        return InstrumentedDatastoreWriter.super.add(entities);
    }

    @Override
    default public void update(Entity ... entities) {
        InstrumentedDatastoreWriter.super.update(entities);
    }

    @Override
    default public void delete(Key ... keys) {
        InstrumentedDatastoreWriter.super.delete(keys);
    }

    @Override
    default public Entity put(FullEntity<?> entity) {
        return InstrumentedDatastoreWriter.super.put(entity);
    }

    @Override
    default public List<Entity> put(FullEntity<?> ... entities) {
        return InstrumentedDatastoreWriter.super.put(entities);
    }

    public static InstrumentedDatastoreBatchWriter of(final Stats stats, final Batch batch) {
        Objects.requireNonNull(stats, "stats");
        Objects.requireNonNull(batch, "batch");
        return new InstrumentedDatastoreBatchWriter(){

            @Override
            public Stats stats() {
                return stats;
            }

            @Override
            public Batch batch() {
                return batch;
            }

            @Override
            public DatastoreWriter writer() {
                return batch;
            }
        };
    }
}

