/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.storage;

import com.google.cloud.datastore.DatastoreReader;
import com.google.cloud.datastore.Entity;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.Query;
import com.google.cloud.datastore.QueryResults;
import com.spotify.styx.monitoring.Stats;
import com.spotify.styx.storage.InstrumentedQueryResults;
import java.util.Iterator;
import java.util.List;

interface InstrumentedDatastoreReader
extends DatastoreReader {
    public Stats stats();

    public DatastoreReader reader();

    default public Entity get(Key key) {
        this.stats().recordDatastoreEntityReads(key.getKind(), 1);
        return this.reader().get(key);
    }

    default public Iterator<Entity> get(Key ... keys) {
        for (Key key : keys) {
            this.stats().recordDatastoreEntityReads(key.getKind(), 1);
        }
        return this.reader().get(keys);
    }

    default public List<Entity> fetch(Key ... keys) {
        for (Key key : keys) {
            this.stats().recordDatastoreEntityReads(key.getKind(), 1);
        }
        return this.reader().fetch(keys);
    }

    default public <T> QueryResults<T> run(Query<T> query) {
        QueryResults results = this.reader().run(query);
        return InstrumentedQueryResults.of(this.stats(), query, results);
    }
}

