/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.storage;

import com.google.cloud.datastore.DatastoreWriter;
import com.google.cloud.datastore.Entity;
import com.google.cloud.datastore.FullEntity;
import com.google.cloud.datastore.Key;
import com.spotify.styx.monitoring.Stats;
import java.util.List;

interface InstrumentedDatastoreWriter
extends DatastoreWriter {
    public Stats stats();

    public DatastoreWriter writer();

    default public Entity add(FullEntity<?> entity) {
        this.stats().recordDatastoreEntityWrites(entity.getKey().getKind(), 1);
        return this.writer().add(entity);
    }

    default public List<Entity> add(FullEntity<?> ... entities) {
        for (FullEntity<?> entity : entities) {
            this.stats().recordDatastoreEntityWrites(entity.getKey().getKind(), 1);
        }
        return this.writer().add(entities);
    }

    default public void update(Entity ... entities) {
        for (Entity entity : entities) {
            this.stats().recordDatastoreEntityWrites(((Key)entity.getKey()).getKind(), 1);
        }
        this.writer().update(entities);
    }

    default public Entity put(FullEntity<?> entity) {
        this.stats().recordDatastoreEntityWrites(entity.getKey().getKind(), 1);
        return this.writer().put(entity);
    }

    default public List<Entity> put(FullEntity<?> ... entities) {
        for (FullEntity<?> entity : entities) {
            this.stats().recordDatastoreEntityWrites(entity.getKey().getKind(), 1);
        }
        return this.writer().put(entities);
    }

    default public void delete(Key ... keys) {
        for (Key key : keys) {
            this.stats().recordDatastoreEntityDeletes(key.getKind(), 1);
        }
        this.writer().delete(keys);
    }
}

