/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.storage;

import com.google.cloud.datastore.Cursor;
import com.google.cloud.datastore.GqlQuery;
import com.google.cloud.datastore.KeyQuery;
import com.google.cloud.datastore.ProjectionEntityQuery;
import com.google.cloud.datastore.Query;
import com.google.cloud.datastore.QueryResults;
import com.google.cloud.datastore.StructuredQuery;
import com.spotify.styx.monitoring.Stats;
import java.util.Objects;

class InstrumentedQueryResults<T>
implements QueryResults<T> {
    private final Stats stats;
    private final String kind;
    private final QueryResults<T> results;

    private InstrumentedQueryResults(Stats stats, String kind, QueryResults<T> results) {
        this.stats = Objects.requireNonNull(stats, "stats");
        this.kind = Objects.requireNonNull(kind, "kind");
        this.results = Objects.requireNonNull(results, "results");
    }

    static <T> QueryResults<T> of(Stats stats, Query<T> query, QueryResults<T> results) {
        String kind = InstrumentedQueryResults.queryKind(query);
        stats.recordDatastoreQueries(kind, 1);
        if (query instanceof KeyQuery) {
            return results;
        }
        if (query instanceof ProjectionEntityQuery && ((ProjectionEntityQuery)query).getDistinctOn().isEmpty()) {
            return results;
        }
        return new InstrumentedQueryResults<T>(stats, kind, results);
    }

    public Class<?> getResultClass() {
        return this.results.getResultClass();
    }

    public Cursor getCursorAfter() {
        return this.results.getCursorAfter();
    }

    public boolean hasNext() {
        return this.results.hasNext();
    }

    public T next() {
        Object value = this.results.next();
        this.stats.recordDatastoreEntityReads(this.kind, 1);
        return (T)value;
    }

    private static <T> String queryKind(Query<T> query) {
        String kind = query instanceof StructuredQuery ? ((StructuredQuery)query).getKind() : (query instanceof GqlQuery ? "<gql>" : "<unknown>");
        return kind;
    }
}

