/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.storage;

import com.google.cloud.datastore.Batch;
import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.DatastoreReaderWriter;
import com.google.cloud.datastore.Entity;
import com.google.cloud.datastore.FullEntity;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.Query;
import com.google.cloud.datastore.QueryResults;
import com.google.cloud.datastore.Transaction;
import com.google.protobuf.ByteString;
import com.spotify.styx.monitoring.Stats;
import com.spotify.styx.storage.InstrumentedDatastoreBatchWriter;
import com.spotify.styx.storage.InstrumentedDatastoreReaderWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

interface InstrumentedTransaction
extends Transaction,
InstrumentedDatastoreBatchWriter,
InstrumentedDatastoreReaderWriter {
    public Transaction transaction();

    @Override
    default public Entity get(Key key) {
        return InstrumentedDatastoreReaderWriter.super.get(key);
    }

    @Override
    default public Iterator<Entity> get(Key ... key) {
        return InstrumentedDatastoreReaderWriter.super.get(key);
    }

    @Override
    default public List<Entity> fetch(Key ... keys) {
        return InstrumentedDatastoreReaderWriter.super.fetch(keys);
    }

    @Override
    default public <T> QueryResults<T> run(Query<T> query) {
        return InstrumentedDatastoreReaderWriter.super.run(query);
    }

    @Override
    default public void addWithDeferredIdAllocation(FullEntity<?> ... entities) {
        InstrumentedDatastoreBatchWriter.super.addWithDeferredIdAllocation(entities);
    }

    @Override
    default public Entity add(FullEntity<?> entity) {
        return InstrumentedDatastoreBatchWriter.super.add(entity);
    }

    @Override
    default public List<Entity> add(FullEntity<?> ... entities) {
        return InstrumentedDatastoreBatchWriter.super.add(entities);
    }

    @Override
    default public void update(Entity ... entities) {
        InstrumentedDatastoreBatchWriter.super.update(entities);
    }

    @Override
    default public void delete(Key ... keys) {
        InstrumentedDatastoreBatchWriter.super.delete(keys);
    }

    @Override
    default public void putWithDeferredIdAllocation(FullEntity<?> ... entities) {
        InstrumentedDatastoreBatchWriter.super.putWithDeferredIdAllocation(entities);
    }

    @Override
    default public Entity put(FullEntity<?> entity) {
        return InstrumentedDatastoreBatchWriter.super.put(entity);
    }

    @Override
    default public List<Entity> put(FullEntity<?> ... entities) {
        return InstrumentedDatastoreBatchWriter.super.put(entities);
    }

    default public Transaction.Response commit() {
        return this.transaction().commit();
    }

    default public void rollback() {
        this.transaction().rollback();
    }

    @Override
    default public boolean isActive() {
        return InstrumentedDatastoreBatchWriter.super.isActive();
    }

    @Override
    default public Datastore getDatastore() {
        return InstrumentedDatastoreBatchWriter.super.getDatastore();
    }

    default public ByteString getTransactionId() {
        return this.transaction().getTransactionId();
    }

    @Override
    default public Batch batch() {
        return new Batch(){

            public Entity add(FullEntity<?> entity) {
                return InstrumentedTransaction.this.transaction().add(entity);
            }

            public List<Entity> add(FullEntity<?> ... entities) {
                return InstrumentedTransaction.this.transaction().add(new FullEntity[0]);
            }

            public Batch.Response submit() {
                throw new UnsupportedOperationException();
            }

            public Datastore getDatastore() {
                return InstrumentedTransaction.this.transaction().getDatastore();
            }

            public void addWithDeferredIdAllocation(FullEntity<?> ... entities) {
                InstrumentedTransaction.this.transaction().addWithDeferredIdAllocation(entities);
            }

            public void update(Entity ... entities) {
                InstrumentedTransaction.this.transaction().update(entities);
            }

            public void delete(Key ... keys) {
                InstrumentedTransaction.this.transaction().delete(keys);
            }

            public void putWithDeferredIdAllocation(FullEntity<?> ... entities) {
                InstrumentedTransaction.this.transaction().putWithDeferredIdAllocation(entities);
            }

            public Entity put(FullEntity<?> entity) {
                return InstrumentedTransaction.this.transaction().put(entity);
            }

            public List<Entity> put(FullEntity<?> ... entities) {
                return InstrumentedTransaction.this.transaction().put(new FullEntity[0]);
            }

            public boolean isActive() {
                return InstrumentedTransaction.this.transaction().isActive();
            }
        };
    }

    @Override
    default public DatastoreReaderWriter readerWriter() {
        return this.transaction();
    }

    public static InstrumentedTransaction of(final Stats stats, final Transaction transaction) {
        Objects.requireNonNull(stats, "stats");
        Objects.requireNonNull(transaction, "transaction");
        return new InstrumentedTransaction(){

            @Override
            public Transaction transaction() {
                return transaction;
            }

            @Override
            public Stats stats() {
                return stats;
            }
        };
    }
}

