/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.storage;

import com.spotify.styx.model.Backfill;
import com.spotify.styx.model.Resource;
import com.spotify.styx.model.SequenceEvent;
import com.spotify.styx.model.StyxConfig;
import com.spotify.styx.model.Workflow;
import com.spotify.styx.model.WorkflowId;
import com.spotify.styx.model.WorkflowInstance;
import com.spotify.styx.model.WorkflowState;
import com.spotify.styx.model.data.WorkflowInstanceExecutionData;
import com.spotify.styx.state.RunState;
import com.spotify.styx.storage.TransactionFunction;
import com.spotify.styx.util.TriggerInstantSpec;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;

public interface Storage
extends Closeable {
    public static final String GLOBAL_RESOURCE_ID = "GLOBAL_STYX_CLUSTER";

    public SortedSet<SequenceEvent> readEvents(WorkflowInstance var1) throws IOException;

    public void writeEvent(SequenceEvent var1) throws IOException;

    public Optional<Long> getLatestStoredCounter(WorkflowInstance var1) throws IOException;

    public StyxConfig config() throws IOException;

    public void storeWorkflow(Workflow var1) throws IOException;

    public Optional<Workflow> workflow(WorkflowId var1) throws IOException;

    public List<Workflow> workflows(String var1) throws IOException;

    public void delete(WorkflowId var1) throws IOException;

    public void updateNextNaturalTrigger(WorkflowId var1, TriggerInstantSpec var2) throws IOException;

    public Map<Workflow, TriggerInstantSpec> workflowsWithNextNaturalTrigger() throws IOException;

    public Map<WorkflowId, Workflow> workflows() throws IOException;

    public Map<WorkflowId, Workflow> workflows(Set<WorkflowId> var1);

    public void writeActiveState(WorkflowInstance var1, RunState var2) throws IOException;

    public void deleteActiveState(WorkflowInstance var1) throws IOException;

    public Map<WorkflowInstance, RunState> readActiveStates() throws IOException;

    public Map<WorkflowInstance, RunState> readActiveStates(String var1) throws IOException;

    public Optional<RunState> readActiveState(WorkflowInstance var1) throws IOException;

    public Map<WorkflowInstance, RunState> readActiveStatesByTriggerId(String var1) throws IOException;

    public WorkflowInstanceExecutionData executionData(WorkflowInstance var1) throws IOException;

    public List<WorkflowInstanceExecutionData> executionData(WorkflowId var1, String var2, int var3) throws IOException;

    public List<WorkflowInstanceExecutionData> executionData(WorkflowId var1, String var2, String var3) throws IOException;

    @Deprecated
    public boolean enabled(WorkflowId var1) throws IOException;

    public Set<WorkflowId> enabled() throws IOException;

    public void patchState(WorkflowId var1, WorkflowState var2) throws IOException;

    public WorkflowState workflowState(WorkflowId var1) throws IOException;

    public Optional<Resource> resource(String var1) throws IOException;

    public void storeResource(Resource var1) throws IOException;

    public List<Resource> resources() throws IOException;

    public void deleteResource(String var1) throws IOException;

    public List<Backfill> backfills(boolean var1) throws IOException;

    public List<Backfill> backfillsForComponent(boolean var1, String var2) throws IOException;

    public List<Backfill> backfillsForWorkflow(boolean var1, String var2) throws IOException;

    public List<Backfill> backfillsForWorkflowId(boolean var1, WorkflowId var2) throws IOException;

    public Optional<Backfill> backfill(String var1) throws IOException;

    public void storeBackfill(Backfill var1) throws IOException;

    public Map<Integer, Long> shardsForCounter(String var1) throws IOException;

    public long getLimitForCounter(String var1) throws IOException;

    public <T, E extends Exception> T runInTransaction(TransactionFunction<T, E> var1) throws IOException, E;
}

