/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.storage;

import com.spotify.styx.model.Backfill;
import com.spotify.styx.model.Resource;
import com.spotify.styx.model.Workflow;
import com.spotify.styx.model.WorkflowId;
import com.spotify.styx.model.WorkflowInstance;
import com.spotify.styx.model.WorkflowState;
import com.spotify.styx.state.RunState;
import com.spotify.styx.storage.TransactionException;
import com.spotify.styx.util.Shard;
import com.spotify.styx.util.ShardedCounter;
import com.spotify.styx.util.TriggerInstantSpec;
import java.io.IOException;
import java.util.Optional;

public interface StorageTransaction {
    public WorkflowId store(Workflow var1) throws IOException;

    public WorkflowId storeWorkflowWithNextNaturalTrigger(Workflow var1, TriggerInstantSpec var2) throws IOException;

    public Optional<Workflow> workflow(WorkflowId var1) throws IOException;

    public Optional<Backfill> backfill(String var1) throws IOException;

    public WorkflowId updateNextNaturalTrigger(WorkflowId var1, TriggerInstantSpec var2) throws IOException;

    public WorkflowId patchState(WorkflowId var1, WorkflowState var2) throws IOException;

    public Optional<RunState> readActiveState(WorkflowInstance var1) throws IOException;

    public WorkflowInstance writeActiveState(WorkflowInstance var1, RunState var2) throws IOException;

    public WorkflowInstance updateActiveState(WorkflowInstance var1, RunState var2) throws IOException;

    public WorkflowInstance deleteActiveState(WorkflowInstance var1) throws IOException;

    public Backfill store(Backfill var1) throws IOException;

    public void commit() throws TransactionException;

    public void rollback() throws TransactionException;

    public boolean isActive();

    public void updateCounter(ShardedCounter var1, String var2, int var3) throws IOException;

    public Optional<Shard> shard(String var1, int var2) throws IOException;

    public void store(Shard var1) throws IOException;

    public void updateLimitForCounter(String var1, long var2) throws IOException;

    public void store(Resource var1) throws IOException;
}

