/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.storage;

import com.google.cloud.datastore.DatastoreException;
import com.spotify.styx.storage.StorageException;

public class TransactionException
extends StorageException {
    public TransactionException(DatastoreException cause) {
        super(cause.getMessage(), cause);
    }

    public boolean isConflict() {
        if (this.getCause() != null && this.getCause() instanceof DatastoreException) {
            DatastoreException datastoreException = (DatastoreException)this.getCause();
            return datastoreException.getCode() == 10;
        }
        return false;
    }

    public boolean isAlreadyExists() {
        if (this.getCause() != null && this.getCause() instanceof DatastoreException) {
            DatastoreException datastoreException = (DatastoreException)this.getCause();
            return "ALREADY_EXISTS".equals(datastoreException.getReason()) || this.messageStartsWith("entity already exists");
        }
        return false;
    }

    public boolean isNotFound() {
        if (this.getCause() != null && this.getCause() instanceof DatastoreException) {
            DatastoreException datastoreException = (DatastoreException)this.getCause();
            return "NOT_FOUND".equals(datastoreException.getReason()) || this.messageStartsWith("no entity to update");
        }
        return false;
    }

    private boolean messageStartsWith(String prefix) {
        String message = this.getMessage();
        return message != null && message.startsWith(prefix);
    }
}

