/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.util;

import com.google.cloud.bigtable.hbase.BigtableConfiguration;
import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.DatastoreOptions;
import com.spotify.styx.monitoring.Stats;
import com.spotify.styx.storage.InstrumentedDatastore;
import com.typesafe.config.Config;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Connections {
    private static final Logger LOG = LoggerFactory.getLogger(Connections.class);
    public static final String DATASTORE_PROJECT = "styx.datastore.project-id";
    public static final String DATASTORE_NAMESPACE = "styx.datastore.namespace";
    public static final String BIGTABLE_PROJECT_ID = "styx.bigtable.project-id";
    public static final String BIGTABLE_INSTANCE_ID = "styx.bigtable.instance-id";

    private Connections() {
    }

    public static InstrumentedDatastore createDatastore(Config config, Stats stats) {
        String projectId = config.getString(DATASTORE_PROJECT);
        String namespace = config.getString(DATASTORE_NAMESPACE);
        LOG.info("Creating Datastore connection for project:{}, namespace:{}", (Object)projectId, (Object)namespace);
        Datastore datastore = (Datastore)((DatastoreOptions.Builder)DatastoreOptions.newBuilder().setNamespace(namespace).setProjectId(projectId)).build().getService();
        return InstrumentedDatastore.of(datastore, stats);
    }

    public static Connection createBigTableConnection(Config config) {
        String projectId = config.getString(BIGTABLE_PROJECT_ID);
        String instanceId = config.getString(BIGTABLE_INSTANCE_ID);
        LOG.info("Creating Bigtable connection for project:{}, instance:{}", (Object)projectId, (Object)instanceId);
        Configuration bigtableConfiguration = new Configuration();
        bigtableConfiguration.set("google.bigtable.project.id", projectId);
        bigtableConfiguration.set("google.bigtable.instance.id", instanceId);
        bigtableConfiguration.setBoolean("google.bigtable.rpc.use.timeouts", true);
        return BigtableConfiguration.connect((Configuration)bigtableConfiguration);
    }
}

