/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.util;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FutureUtil {
    private FutureUtil() {
        throw new UnsupportedOperationException();
    }

    public static <T> CompletableFuture<T> exceptionallyCompletedFuture(Throwable t) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(t);
        return future;
    }

    public static <T> List<T> gatherIO(List<Future<T>> futures, long timeout, TimeUnit timeUnit) throws IOException {
        ImmutableList.Builder values = ImmutableList.builder();
        for (Future<T> future : futures) {
            try {
                values.add(future.get(timeout, timeUnit));
            }
            catch (TimeoutException e) {
                throw new IOException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                Throwables.propagateIfPossible((Throwable)cause, IOException.class);
                throw new RuntimeException(cause);
            }
        }
        return values.build();
    }
}

