/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.util;

import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import java.util.Optional;

public class GcpUtil {
    private GcpUtil() {
        throw new UnsupportedOperationException();
    }

    public static boolean isPermissionDenied(Throwable t) {
        return t instanceof GoogleJsonResponseException && GcpUtil.isPermissionDenied((GoogleJsonResponseException)t);
    }

    public static boolean isPermissionDenied(GoogleJsonResponseException e) {
        return e.getStatusCode() == 403 && Optional.ofNullable(e.getDetails()).map(GcpUtil::isPermissionDenied).orElse(false) != false;
    }

    public static boolean isPermissionDenied(GoogleJsonError error) {
        return "PERMISSION_DENIED".equals(error.get((Object)"status"));
    }

    public static boolean isResourceExhausted(Throwable t) {
        return t instanceof GoogleJsonResponseException && GcpUtil.isResourceExhausted((GoogleJsonResponseException)t);
    }

    public static boolean isResourceExhausted(GoogleJsonResponseException e) {
        return e.getStatusCode() == 429 && Optional.ofNullable(e.getDetails()).map(GcpUtil::isResourceExhausted).orElse(false) != false;
    }

    public static boolean isResourceExhausted(GoogleJsonError error) {
        return "RESOURCE_EXHAUSTED".equals(error.get((Object)"status"));
    }
}

