/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.util;

import io.grpc.Context;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;

public class GrpcContextUtil {
    private GrpcContextUtil() {
        throw new UnsupportedOperationException();
    }

    public static ExecutorService currentContextExecutorService(ExecutorService executorService) {
        return new CurrentContextExecutorService(executorService);
    }

    private static class CurrentContextExecutorService
    extends AbstractExecutorService {
        private final ExecutorService executorService;

        CurrentContextExecutorService(ExecutorService executorService) {
            this.executorService = Objects.requireNonNull(executorService, "executorService");
        }

        @Override
        public void shutdown() {
            this.executorService.shutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            return this.executorService.shutdownNow();
        }

        @Override
        public boolean isShutdown() {
            return this.executorService.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.executorService.isTerminated();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.executorService.awaitTermination(timeout, unit);
        }

        @Override
        public void execute(Runnable command) {
            this.executorService.execute(Context.current().wrap(command));
        }

        @Override
        protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
            return super.newTaskFor(Context.current().wrap(runnable), value);
        }

        @Override
        protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
            return super.newTaskFor(Context.current().wrap(callable));
        }
    }
}

