/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.util;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class MDCUtil {
    private static final Logger log = LoggerFactory.getLogger(MDCUtil.class);

    private MDCUtil() {
        throw new UnsupportedOperationException();
    }

    public static Executor withMDC() {
        return runnable -> ForkJoinPool.commonPool().execute(MDCUtil.withMDC(runnable));
    }

    public static Executor withMDC(Executor executor) {
        return runnable -> executor.execute(MDCUtil.withMDC(runnable));
    }

    public static Runnable withMDC(final Runnable r) {
        return new Runnable(){
            private final Map<String, String> contextMap = MDCUtil.access$000();

            @Override
            public void run() {
                MDCUtil.safeSetContextMap(this.contextMap);
                try {
                    r.run();
                }
                finally {
                    MDCUtil.safeResetContextMap();
                }
            }
        };
    }

    public static <V> Callable<V> withMDC(final Callable<V> r) {
        return new Callable<V>(){
            private final Map<String, String> contextMap = MDCUtil.access$000();

            @Override
            public V call() throws Exception {
                MDCUtil.safeSetContextMap(this.contextMap);
                try {
                    Object v = r.call();
                    return v;
                }
                finally {
                    MDCUtil.safeResetContextMap();
                }
            }
        };
    }

    private static Map<String, String> safeCopyOfContextMap() {
        try {
            return MDC.getCopyOfContextMap();
        }
        catch (Exception e) {
            log.error("Failed to copy MDC", (Throwable)e);
            return null;
        }
    }

    private static void safeSetContextMap(Map<String, String> contextMap) {
        try {
            if (contextMap != null) {
                MDC.setContextMap(contextMap);
            } else {
                MDC.clear();
            }
        }
        catch (Exception e) {
            log.error("Failed to set MDC", (Throwable)e);
        }
    }

    private static void safeResetContextMap() {
        try {
            MDC.clear();
        }
        catch (Exception e) {
            log.error("Failed to reset MDC", (Throwable)e);
        }
    }

    public static MDC.MDCCloseable safePutCloseable(String key, String value) {
        try {
            return MDC.putCloseable((String)key, (String)value);
        }
        catch (Exception e) {
            log.error("Failed to put MDC", (Throwable)e);
            return null;
        }
    }

    static /* synthetic */ Map access$000() {
        return MDCUtil.safeCopyOfContextMap();
    }
}

