/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.util;

import com.spotify.styx.api.RunStateDataPayload;
import com.spotify.styx.model.SequenceEvent;
import com.spotify.styx.model.WorkflowInstance;
import com.spotify.styx.state.RunState;
import com.spotify.styx.storage.Storage;
import com.spotify.styx.util.EventUtil;
import com.spotify.styx.util.Time;
import com.spotify.styx.util.TriggerUtil;
import java.io.IOException;
import java.time.Instant;
import java.util.Optional;
import java.util.SortedSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReplayEvents {
    private static final Logger LOG = LoggerFactory.getLogger(ReplayEvents.class);

    private ReplayEvents() {
        throw new UnsupportedOperationException();
    }

    public static Optional<RunStateDataPayload.RunStateData> getBackfillRunStateData(WorkflowInstance workflowInstance, Storage storage, String backfillId) {
        SortedSet<SequenceEvent> sequenceEvents = ReplayEvents.getSequenceEvents(workflowInstance, storage);
        if (sequenceEvents.isEmpty()) {
            return Optional.empty();
        }
        SettableTime time = new SettableTime();
        RunState restoredState = RunState.fresh(workflowInstance, time);
        boolean backfillFound = false;
        SettableTime initialTime = new SettableTime();
        SettableTime latestTime = new SettableTime();
        for (SequenceEvent sequenceEvent : sequenceEvents) {
            time.set(Instant.ofEpochMilli(sequenceEvent.timestamp()));
            boolean triggerExecutionEventMet = "triggerExecution".equals(EventUtil.name(sequenceEvent.event()));
            if (triggerExecutionEventMet) {
                if (backfillFound) break;
                restoredState = RunState.fresh(workflowInstance, time);
                initialTime.set(time.get());
            }
            try {
                restoredState = restoredState.transition(sequenceEvent.event(), time);
            }
            catch (IllegalStateException e) {
                LOG.warn("failed to transition state, move on to next event", (Throwable)e);
            }
            latestTime.set(time.get());
            if (!ReplayEvents.backfillFound(triggerExecutionEventMet, backfillId, restoredState)) continue;
            backfillFound = true;
        }
        if (backfillFound) {
            RunStateDataPayload.RunStateData runStateData = RunStateDataPayload.RunStateData.newBuilder().workflowInstance(restoredState.workflowInstance()).state(restoredState.state().name()).stateData(restoredState.data()).initialTimestamp(initialTime.get().toEpochMilli()).latestTimestamp(latestTime.get().toEpochMilli()).build();
            return Optional.of(runStateData);
        }
        return Optional.empty();
    }

    private static SortedSet<SequenceEvent> getSequenceEvents(WorkflowInstance workflowInstance, Storage storage) {
        SortedSet<SequenceEvent> sequenceEvents;
        try {
            sequenceEvents = storage.readEvents(workflowInstance);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sequenceEvents;
    }

    private static boolean backfillFound(boolean triggerExecutionEventMet, String backfillId, RunState restoredState) {
        return triggerExecutionEventMet && restoredState.data().trigger().map(trigger -> backfillId.equals(TriggerUtil.triggerId(trigger))).orElse(false) != false;
    }

    private static final class SettableTime
    implements Time {
        private Instant now = Instant.now();

        private SettableTime() {
        }

        @Override
        public Instant get() {
            return this.now;
        }

        void set(Instant time) {
            this.now = time;
        }
    }
}

