/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.util;

import com.spotify.styx.storage.Storage;
import com.spotify.styx.util.CounterSnapshotFactory;
import com.spotify.styx.util.Shard;
import com.spotify.styx.util.ShardedCounter;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardedCounterSnapshotFactory
implements CounterSnapshotFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ShardedCounterSnapshotFactory.class);
    static final int TRANSACTION_GROUP_SIZE = 25;
    private final Storage storage;

    public ShardedCounterSnapshotFactory(Storage storage) {
        this.storage = Objects.requireNonNull(storage);
    }

    @Override
    public ShardedCounter.Snapshot create(String counterId) throws IOException {
        return new ShardedCounter.Snapshot(counterId, ShardedCounter.getLimit(this.storage, counterId), ShardedCounterSnapshotFactory.getShards(this.storage, counterId));
    }

    private static Map<Integer, Long> getShards(Storage storage, String counterId) throws IOException {
        Map<Integer, Long> fetchedShards = storage.shardsForCounter(counterId);
        if (fetchedShards.size() < 128) {
            ShardedCounterSnapshotFactory.initialize(storage, counterId);
            fetchedShards = storage.shardsForCounter(counterId);
        }
        return fetchedShards;
    }

    private static void initialize(Storage storage, String counterId) {
        LOG.debug("Initializing counter shards for resource {}", (Object)counterId);
        for (int startIndex = 0; startIndex < 128; startIndex += 25) {
            ShardedCounterSnapshotFactory.initShardRange(storage, counterId, startIndex, Math.min(128, startIndex + 25));
        }
    }

    private static void initShardRange(Storage storage, String counterId, int startIndex, int endIndex) {
        try {
            storage.runInTransaction(tx -> {
                for (int index = startIndex; index < endIndex; ++index) {
                    Optional<Shard> shard = tx.shard(counterId, index);
                    if (shard.isPresent()) continue;
                    tx.store(Shard.create(counterId, index, 0));
                }
                return null;
            });
        }
        catch (IOException e) {
            LOG.warn("Error when trying to create a group of shards in Datastore: ", (Throwable)e);
        }
    }
}

