/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.util;

import com.spotify.styx.model.Workflow;
import com.spotify.styx.model.WorkflowConfiguration;
import com.spotify.styx.util.DockerImageValidator;
import com.spotify.styx.util.TimeUtil;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class WorkflowValidator {
    static final long MAX_ID_LENGTH = 256L;
    static final long MAX_DOCKER_ARGS_TOTAL = 1000000L;
    static final long MAX_RESOURCES = 5L;
    static final long MAX_RESOURCE_LENGTH = 256L;
    static final long MAX_COMMIT_SHA_LENGTH = 256L;
    static final long MAX_SECRET_NAME_LENGTH = 253L;
    static final long MAX_SECRET_MOUNT_PATH_LENGTH = 1024L;
    static final long MAX_SERVICE_ACCOUNT_LENGTH = 256L;
    static final long MAX_ENV_VARS = 128L;
    static final long MAX_ENV_SIZE = 16384L;
    private final DockerImageValidator dockerImageValidator;

    public WorkflowValidator(DockerImageValidator dockerImageValidator) {
        this.dockerImageValidator = dockerImageValidator;
    }

    public List<String> validateWorkflow(Workflow workflow) {
        WorkflowConfiguration configuration = workflow.configuration();
        return this.validateWorkflowConfiguration(configuration);
    }

    public List<String> validateWorkflowConfiguration(WorkflowConfiguration cfg) {
        ArrayList<String> e = new ArrayList<String>();
        this.limit(e, cfg.id().length(), 256L, "id too long");
        this.limit(e, cfg.commitSha().map(String::length).orElse(0).intValue(), 256L, "commitSha too long");
        this.limit(e, cfg.secret().map(s -> s.name().length()).orElse(0).intValue(), 253L, "secret name too long");
        this.limit(e, cfg.secret().map(s -> s.mountPath().length()).orElse(0).intValue(), 1024L, "secret mount path too long");
        this.limit(e, cfg.serviceAccount().map(String::length).orElse(0).intValue(), 256L, "service account too long");
        this.limit(e, cfg.resources().size(), 5L, "too many resources");
        this.limit(e, cfg.env().size(), 128L, "too many env vars");
        this.limit(e, cfg.env().entrySet().stream().mapToLong(entry -> ((String)entry.getKey()).length() + ((String)entry.getValue()).length()).sum(), 16384L, "env too big");
        cfg.dockerImage().ifPresent(image -> this.dockerImageValidator.validateImageReference((String)image).stream().map(s -> "invalid image: " + s).forEach(e::add));
        cfg.resources().stream().map(String::length).forEach(v -> this.limit((List<String>)e, v.intValue(), 256L, "resource name too long"));
        this.limit(e, cfg.dockerArgs().map(args -> (long)args.size() + args.stream().mapToLong(String::length).sum()), 1000000L, "docker args is too large");
        cfg.offset().ifPresent(offset -> {
            try {
                TimeUtil.addOffset(ZonedDateTime.now(), offset);
            }
            catch (DateTimeParseException ex) {
                e.add(String.format("invalid offset: %s", ex.getMessage()));
            }
        });
        try {
            TimeUtil.cron(cfg.schedule());
        }
        catch (IllegalArgumentException ex) {
            e.add("invalid schedule");
        }
        return e;
    }

    private void limit(List<String> errors, Optional<Long> value, long limit, String message) {
        value.ifPresent(v -> this.limit(errors, (long)v, limit, message));
    }

    private void limit(List<String> errors, long value, long limit, String message) {
        if (value > limit) {
            errors.add(message + ": " + value + ", limit = " + limit);
        }
    }
}

