/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.model;

import com.spotify.styx.model.ExecutionDescriptionBuilder;
import com.spotify.styx.model.FlyteExecConf;
import io.norberg.automatter.AutoMatter;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@AutoMatter
public interface ExecutionDescription {
    public Optional<String> dockerImage();

    public List<String> dockerArgs();

    public boolean dockerTerminationLogging();

    public Optional<String> serviceAccount();

    public Optional<String> commitSha();

    public Map<String, String> env();

    public Optional<Duration> runningTimeout();

    public Optional<String> retryCondition();

    public Optional<FlyteExecConf> flyteExecConf();

    public Optional<String> flyteExecutionId();

    public static ExecutionDescriptionBuilder builder() {
        return new ExecutionDescriptionBuilder();
    }

    public static ExecutionDescription forImage(String dockerImage) {
        return ExecutionDescription.builder().dockerImage(dockerImage).build();
    }
}

