/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.model;

import com.spotify.styx.model.FlyteIdentifier;
import io.norberg.automatter.AutoMatter;

public final class FlyteIdentifierBuilder {
    private String resourceType;
    private String project;
    private String domain;
    private String name;
    private String version;

    public FlyteIdentifierBuilder() {
    }

    private FlyteIdentifierBuilder(FlyteIdentifier v) {
        this.resourceType = v.resourceType();
        this.project = v.project();
        this.domain = v.domain();
        this.name = v.name();
        this.version = v.version();
    }

    private FlyteIdentifierBuilder(FlyteIdentifierBuilder v) {
        this.resourceType = v.resourceType;
        this.project = v.project;
        this.domain = v.domain;
        this.name = v.name;
        this.version = v.version;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public FlyteIdentifierBuilder resourceType(String resourceType) {
        if (resourceType == null) {
            throw new NullPointerException("resourceType");
        }
        this.resourceType = resourceType;
        return this;
    }

    public String project() {
        return this.project;
    }

    public FlyteIdentifierBuilder project(String project) {
        if (project == null) {
            throw new NullPointerException("project");
        }
        this.project = project;
        return this;
    }

    public String domain() {
        return this.domain;
    }

    public FlyteIdentifierBuilder domain(String domain) {
        if (domain == null) {
            throw new NullPointerException("domain");
        }
        this.domain = domain;
        return this;
    }

    public String name() {
        return this.name;
    }

    public FlyteIdentifierBuilder name(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.name = name;
        return this;
    }

    public String version() {
        return this.version;
    }

    public FlyteIdentifierBuilder version(String version) {
        if (version == null) {
            throw new NullPointerException("version");
        }
        this.version = version;
        return this;
    }

    public FlyteIdentifier build() {
        return new Value(this.resourceType, this.project, this.domain, this.name, this.version);
    }

    public static FlyteIdentifierBuilder from(FlyteIdentifier v) {
        return new FlyteIdentifierBuilder(v);
    }

    public static FlyteIdentifierBuilder from(FlyteIdentifierBuilder v) {
        return new FlyteIdentifierBuilder(v);
    }

    private static final class Value
    implements FlyteIdentifier {
        private final String resourceType;
        private final String project;
        private final String domain;
        private final String name;
        private final String version;

        private Value(@AutoMatter.Field(value="resourceType") String resourceType, @AutoMatter.Field(value="project") String project, @AutoMatter.Field(value="domain") String domain, @AutoMatter.Field(value="name") String name, @AutoMatter.Field(value="version") String version) {
            if (resourceType == null) {
                throw new NullPointerException("resourceType");
            }
            if (project == null) {
                throw new NullPointerException("project");
            }
            if (domain == null) {
                throw new NullPointerException("domain");
            }
            if (name == null) {
                throw new NullPointerException("name");
            }
            if (version == null) {
                throw new NullPointerException("version");
            }
            this.resourceType = resourceType;
            this.project = project;
            this.domain = domain;
            this.name = name;
            this.version = version;
        }

        @Override
        @AutoMatter.Field
        public String resourceType() {
            return this.resourceType;
        }

        @Override
        @AutoMatter.Field
        public String project() {
            return this.project;
        }

        @Override
        @AutoMatter.Field
        public String domain() {
            return this.domain;
        }

        @Override
        @AutoMatter.Field
        public String name() {
            return this.name;
        }

        @Override
        @AutoMatter.Field
        public String version() {
            return this.version;
        }

        @Override
        public FlyteIdentifierBuilder builder() {
            return new FlyteIdentifierBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FlyteIdentifier)) {
                return false;
            }
            FlyteIdentifier that = (FlyteIdentifier)o;
            if (this.resourceType != null ? !this.resourceType.equals(that.resourceType()) : that.resourceType() != null) {
                return false;
            }
            if (this.project != null ? !this.project.equals(that.project()) : that.project() != null) {
                return false;
            }
            if (this.domain != null ? !this.domain.equals(that.domain()) : that.domain() != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(that.name()) : that.name() != null) {
                return false;
            }
            return !(this.version != null ? !this.version.equals(that.version()) : that.version() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.resourceType != null ? this.resourceType.hashCode() : 0);
            result = 31 * result + (this.project != null ? this.project.hashCode() : 0);
            result = 31 * result + (this.domain != null ? this.domain.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
            return result;
        }

        public String toString() {
            return this.urn();
        }
    }
}

