/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.model;

import com.google.auto.value.AutoValue;
import com.spotify.styx.model.AutoValue_SequenceEvent;
import com.spotify.styx.model.Event;
import java.util.Comparator;

@AutoValue
public abstract class SequenceEvent {
    public static final Comparator<SequenceEvent> COUNTER_COMPARATOR = (a, b) -> (int)(a.counter() - b.counter());

    public abstract Event event();

    public abstract long counter();

    public abstract long timestamp();

    public static SequenceEvent create(Event event, long counter, long timestamp) {
        return new AutoValue_SequenceEvent(event, counter, timestamp);
    }

    public static SequenceEvent parseKey(String key, Event event, long timestamp) {
        int lastHashPos = key.lastIndexOf(35);
        if (lastHashPos < 1) {
            throw new IllegalArgumentException("Key must contain a hash '#' sign on position > 0");
        }
        long counter = Long.parseLong(key.substring(lastHashPos + 1));
        return SequenceEvent.create(event, counter, timestamp);
    }
}

