/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.model;

import com.spotify.styx.model.FlyteExecConf;
import com.spotify.styx.model.Schedule;
import com.spotify.styx.model.WorkflowConfigurationBuilder;
import com.spotify.styx.util.TimeUtil;
import io.norberg.automatter.AutoMatter;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@AutoMatter
public interface WorkflowConfiguration {
    public String id();

    public Schedule schedule();

    public Optional<String> offset();

    public Optional<String> commitSha();

    public Optional<String> dockerImage();

    public Optional<List<String>> dockerArgs();

    public boolean dockerTerminationLogging();

    public Optional<String> serviceAccount();

    public List<String> resources();

    public Map<String, String> env();

    public Optional<Duration> runningTimeout();

    public Optional<String> retryCondition();

    public Optional<FlyteExecConf> flyteExecConf();

    default public Instant addOffset(Instant next) {
        String offset = this.offset().orElseGet(this::defaultOffset);
        return TimeUtil.addOffset(next.atZone(ZoneOffset.UTC), offset).toInstant();
    }

    default public Instant subtractOffset(Instant next) {
        String offset = this.offset().orElseGet(this::defaultOffset);
        return TimeUtil.subtractOffset(next.atZone(ZoneOffset.UTC), offset).toInstant();
    }

    default public String defaultOffset() {
        return this.defaultOffset(this.schedule());
    }

    default public String defaultOffset(Schedule schedule) {
        return this.defaultOffset(schedule.wellKnown());
    }

    default public String defaultOffset(Schedule.WellKnown schedule) {
        switch (schedule) {
            case HOURLY: {
                return "PT1H";
            }
            case DAILY: {
                return "P1D";
            }
            case WEEKLY: {
                return "P1W";
            }
            case MONTHLY: {
                return "P1M";
            }
            case YEARLY: {
                return "P1Y";
            }
        }
        return "PT0S";
    }

    public static WorkflowConfigurationBuilder builder() {
        return new WorkflowConfigurationBuilder();
    }
}

