/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.serialization;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.spotify.styx.state.Trigger;
import com.spotify.styx.state.TriggerVisitor;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=PersistentTrigger.class, name="natural"), @JsonSubTypes.Type(value=PersistentTriggerWithId.class, name="adhoc"), @JsonSubTypes.Type(value=PersistentTriggerWithId.class, name="backfill"), @JsonSubTypes.Type(value=PersistentTriggerWithId.class, name="unknown")})
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
public class PersistentTrigger {
    private static final TriggerSerializerVisitor SERIALIZER_VISITOR = new TriggerSerializerVisitor();
    @JsonTypeId
    @JsonProperty(value="@type")
    public final String type;

    @JsonCreator
    PersistentTrigger(@JsonProperty(value="@type") String type) {
        this.type = type;
    }

    public static PersistentTrigger wrap(Trigger trigger) {
        return trigger.accept(SERIALIZER_VISITOR);
    }

    public Trigger toTrigger() {
        switch (this.type) {
            case "natural": {
                return Trigger.natural();
            }
        }
        throw new IllegalStateException("Trigger type " + this.type + " not covered by base PersistentTrigger class");
    }

    private static class TriggerSerializerVisitor
    implements TriggerVisitor<PersistentTrigger> {
        private TriggerSerializerVisitor() {
        }

        @Override
        public PersistentTrigger natural() {
            return new PersistentTrigger("natural");
        }

        @Override
        public PersistentTrigger adhoc(String triggerId) {
            return new PersistentTriggerWithId("adhoc", triggerId);
        }

        @Override
        public PersistentTrigger backfill(String triggerId) {
            return new PersistentTriggerWithId("backfill", triggerId);
        }

        @Override
        public PersistentTrigger unknown(String triggerId) {
            return new PersistentTriggerWithId("unknown", triggerId);
        }
    }

    public static class PersistentTriggerWithId
    extends PersistentTrigger {
        public final String triggerId;

        @JsonCreator
        public PersistentTriggerWithId(@JsonProperty(value="@type") String type, @JsonProperty(value="trigger_id") String triggerId) {
            super(type);
            this.triggerId = triggerId;
        }

        @Override
        public Trigger toTrigger() {
            switch (this.type) {
                case "adhoc": {
                    return Trigger.adhoc(this.triggerId);
                }
                case "backfill": {
                    return Trigger.backfill(this.triggerId);
                }
                case "unknown": {
                    return Trigger.unknown(this.triggerId);
                }
            }
            return super.toTrigger();
        }
    }
}

